import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'cjbh',
    label: '车间编号',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'cjmc',
    label: '车间名称',
    defaultValue: undefined,
    component: 'Input',
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'cjbh',
    title: '车间编号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'cjmc',
    title: '车间名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'bz',
    title: '备注',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '5ca5c9298e2a496686609fcf82ac532b',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 8,
          list: [
            {
              key: '7a332d16ebd44985a3aa537d0ff5249c',
              field: 'cjbh',
              label: '车间编号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入车间编号',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '2dcd0d986bae407d96856c8e2429fb9d',
              field: 'cjmc',
              label: '车间名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入车间名称',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'f82ce5c9b5194e5d978bece54a873e46',
              field: 'bz',
              label: '备注',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入备注',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 0,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: 'd35d556d0a894c16a0431273a40fbba1',
      label: '关联产线',
      field: 'mesBaseCjCxList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesBaseCjCxList',
        columns: [
          {
            key: 'fa3aee9cb4824a3dbeba4e082cecbff9',
            title: '选择产线',
            dataIndex: 'cxid',
            componentType: 'MultiplePopup',
            componentProps: {
              popupType: 'associate',
              width: '100%',
              span: '',
              placeholder: '请选择选择产线',
              showLabel: true,
              disabled: false,
              datasourceType: 'api',
              labelField: 'label',
              valueField: 'value',
              pageSize: 10,
              assoTitle: '选择产线',
              apiConfig: {
                path: '/jcxx//cjcx/getAllChanxian',
                method: 'GET',
                apiId: '52269e0388984736b3c53ad6c074143c',
                apiParams: [
                  {
                    key: '1',
                    title: 'Query Params',
                    tableInfo: [
                      {
                        name: 'cxids',
                        value:
                          '{"bindField":"danXingWenBen3961","fieldKey":"9426d76edb8548beb78804930b692f11"}',
                        description: null,
                        required: false,
                        dataType: null,
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: 'data',
                      },
                    ],
                  },
                  { key: '2', title: 'Header', tableInfo: [] },
                  { key: '3', title: 'Body' },
                ],
                script:
                  'var idList = cxids.split(",");\r\nvar sql=\'select *,id as value,cxmc as label from mes_base_chanxian ?{cxids, where delete_mark=0 and cxbh not in (#{idList})}\';\r\nreturn db.select(sql)\r\n\r\n',
                outputParams: [
                  {
                    name: 'cxbh',
                    tableTitle: '产线编号',
                    bindField: 'cxbh',
                    show: true,
                    width: 150,
                    component: '9fa6172c84874b33aaaed975fce4e708',
                    bindTable: 'mes_base_cj_cx',
                  },
                  {
                    name: 'cxmc',
                    tableTitle: '产线名称',
                    bindField: 'cxmc',
                    show: true,
                    width: 150,
                    component: '6bba93c39ee449fd89ad544c5f6c13fc',
                    bindTable: 'mes_base_cj_cx',
                  },
                ],
              },
              dicOptions: [],
              required: false,
              rules: [],
              events: {
                change:
                  'var ids=\'0\'\nfor(let i=0;i<formModel.mesBaseCjCxList.length;i++){\n\tids=ids+","+formModel.mesBaseCjCxList[i].cxbh\n}\nformModel.danXingWenBen3961=ids',
              },
              isShow: true,
              tooltipConfig: { visible: false, title: '提示文本' },
            },
          },
          {
            key: '9fa6172c84874b33aaaed975fce4e708',
            title: '产线编号',
            dataIndex: 'cxbh',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入产线编号',
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: false,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
            },
          },
          {
            key: '6bba93c39ee449fd89ad544c5f6c13fc',
            title: '产线名称',
            dataIndex: 'cxmc',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入产线名称',
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: false,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        span: '24',
        preloadType: 'api',
        apiConfig: {},
        itemId: '',
        dicOptions: [],
        useSelectButton: false,
        buttonName: '选择数据',
        showLabel: true,
        showComponentBorder: true,
        showBorder: false,
        bordercolor: '#f0f0f0',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        showIndex: false,
        isShow: true,
        multipleHeads: [],
        buttonList: [],
        topButtonList: [],
        isExport: false,
        isImport: false,
        isDeleteSelected: false,
        isListView: false,
        viewList: [],
        isShowAdd: true,
        isShowDelete: true,
        hasCheckedCol: false,
        events: {
          add: '',
          delete:
            'var ids=\'0\'\nfor(let i=0;i<formModel.mesBaseCjCxList.length;i++){\n\tids=ids+","+formModel.mesBaseCjCxList[i].cxbh\n}\nformModel.danXingWenBen3961=ids',
          load: '',
        },
        showPagenation: true,
      },
    },
    {
      key: '9426d76edb8548beb78804930b692f11',
      field: 'danXingWenBen3961',
      label: '隐藏-cxbh集合',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '0',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '0',
        placeholder: '请输入隐藏-cxbh集合',
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: true,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        listStyle: '',
        isSave: true,
        isShow: false,
        scan: false,
        bordered: true,
        isShowAi: false,
        tooltipConfig: { visible: false, title: '提示文本' },
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
