import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'gzx',
    label: '工作项名称',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'gzxbh',
    label: '工作项编号',
    defaultValue: undefined,
    component: 'Input',
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'gzx',
    title: '工作项名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'gzxbh',
    title: '工作项编号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'bz',
    title: '备注',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '746beb54b93f4fe3804e6487bdc7aaea',
      field: 'gzx',
      label: '工作项名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '30%',
        span: '',
        defaultValue: '',
        placeholder: '请输入工作项名称',
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        listStyle: '',
        isSave: false,
        isShow: true,
        scan: false,
        bordered: true,
        isShowAi: false,
        tooltipConfig: { visible: false, title: '提示文本' },
        style: { width: '30%' },
      },
    },
    {
      key: '2fd2e88c049f4ff48b5cd2e77180b754',
      field: 'gzxbh',
      label: '工作项编号',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '30%',
        span: '',
        defaultValue: '',
        placeholder: '请输入工作项编号',
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        listStyle: '',
        isSave: false,
        isShow: true,
        scan: false,
        bordered: true,
        isShowAi: false,
        tooltipConfig: { visible: false, title: '提示文本' },
        style: { width: '30%' },
      },
    },
    {
      key: 'a6939780cca442009bfd37087a8dd15d',
      field: 'bz',
      label: '备注',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '70%',
        span: '',
        defaultValue: '',
        placeholder: '请输入备注',
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        listStyle: '',
        isSave: false,
        isShow: true,
        scan: false,
        bordered: true,
        isShowAi: false,
        tooltipConfig: { visible: false, title: '提示文本' },
        style: { width: '70%' },
      },
    },
    {
      key: '5b49631d86944eb89c8eb6a2448cdfae',
      field: 'gaibian',
      label: '是否可修改',
      type: 'number',
      component: 'InputNumber',
      colProps: { span: 24 },
      defaultValue: 0,
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: 0,
        min: 0,
        max: 100,
        step: 1,
        disabled: false,
        showLabel: true,
        controls: true,
        required: false,
        subTotal: false,
        isShow: false,
        rules: [],
        events: {},
        placeholder: '请输入是否可修改',
        tooltipConfig: { visible: false, title: '提示文本' },
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
