import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'cphm',
    label: '车牌号',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'cllx',
    label: '车辆类型',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2017066632836796418' },
      labelField: 'name',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'clmc',
    label: '车辆名称',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'clbh',
    label: '车辆编号',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'cpxh',
    label: '厂牌型号',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'cjh',
    label: '车架号',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'cksj',
    label: '出库时间',
    defaultValue: undefined,
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD HH:mm:ss',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
  },

  {
    field: 'jcdj',
    label: '精拆登记',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2018139782334705666' },
      labelField: 'name',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'ypy',
    label: '已排液',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2018146494923980802' },
      labelField: 'name',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'wfcl',
    label: '已危废处理',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2018146494923980802' },
      labelField: 'name',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'ypybg',
    label: '已排液报工',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2018146494923980802' },
      labelField: 'name',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'sfcj',
    label: '已拆解',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2018146494923980802' },
      labelField: 'name',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'cphm',
    title: '车牌号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'cllx',
    title: '车辆类型',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'clmc',
    title: '车辆名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'clbh',
    title: '车辆编号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'cpxh',
    title: '厂牌型号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'cjh',
    title: '车架号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'gbzl',
    title: '过磅重量(t)',
    componentType: 'number',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'cksj',
    title: '出库时间',
    componentType: 'date',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'jcdj',
    title: '精拆登记',
    componentType: 'radio',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'ypy',
    title: '已排液',
    componentType: 'radio',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'wfcl',
    title: '已危废处理',
    componentType: 'radio',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'ypybg',
    title: '已排液报工',
    componentType: 'radio',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'sfcj',
    title: '已拆解',
    componentType: 'radio',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '60b6d62fcbd749f8982f84373f97e076',
      field: '',
      label: '',
      type: 'card',
      colProps: { span: 24 },
      component: 'Card',
      children: [
        {
          span: 24,
          name: 'card',
          list: [
            {
              key: '4e3e16ce2d6945a0992e29acbdfa957a',
              field: '',
              label: '',
              type: 'grid',
              colProps: { span: 24 },
              component: 'Grid',
              children: [
                {
                  span: 8,
                  list: [
                    {
                      key: 'ed751fad10d040e1a485cca457dfdb76',
                      field: 'cphm',
                      label: '车牌号',
                      type: 'input',
                      component: 'Input',
                      colProps: { span: 24 },
                      defaultValue: '',
                      componentProps: {
                        width: '100%',
                        span: 7,
                        defaultValue: '',
                        placeholder: '请输入车牌号',
                        maxlength: 50,
                        prefix: '',
                        suffix: '',
                        addonBefore: '',
                        addonAfter: '',
                        disabled: false,
                        allowClear: false,
                        showLabel: true,
                        required: false,
                        rules: [],
                        events: {},
                        listStyle: '',
                        isSave: false,
                        isShow: true,
                        scan: false,
                        bordered: true,
                        isShowAi: false,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        style: { width: '100%' },
                      },
                    },
                  ],
                },
                {
                  span: 8,
                  list: [
                    {
                      key: 'c456168f54424a868e3d29bb5ee65f69',
                      field: 'cllx',
                      label: '车辆类型',
                      type: 'select',
                      component: 'XjrSelect',
                      colProps: { span: 24 },
                      componentProps: {
                        width: '100%',
                        span: 7,
                        placeholder: '请选择下拉选择',
                        showLabel: true,
                        showSearch: false,
                        isMultiple: false,
                        clearable: false,
                        disabled: false,
                        staticOptions: [
                          { key: 1, label: 'Option 1', value: 'Option 1' },
                          { key: 2, label: 'Option 2', value: 'Option 2' },
                          { key: 3, label: 'Option 3', value: 'Option 3' },
                        ],
                        datasourceType: 'dic',
                        params: { itemId: '2017066632836796418' },
                        labelField: 'name',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        itemId: '2017066632836796418',
                        style: { width: '100%' },
                      },
                    },
                  ],
                },
                {
                  span: 8,
                  list: [
                    {
                      key: 'a24abbc443e04ae595c006c0fb4deb0f',
                      field: 'clmc',
                      label: '车辆名称',
                      type: 'input',
                      component: 'Input',
                      colProps: { span: 24 },
                      defaultValue: '',
                      componentProps: {
                        width: '100%',
                        span: 7,
                        defaultValue: '',
                        placeholder: '请输入车辆名称',
                        prefix: '',
                        suffix: '',
                        addonBefore: '',
                        addonAfter: '',
                        disabled: false,
                        allowClear: false,
                        showLabel: true,
                        required: false,
                        rules: [],
                        events: {},
                        listStyle: '',
                        isSave: false,
                        isShow: true,
                        scan: false,
                        bordered: true,
                        isShowAi: false,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        style: { width: '100%' },
                      },
                    },
                  ],
                },
              ],
              componentProps: {
                gutter: 16,
                justify: 'start',
                align: 'top',
                isShow: true,
                showBorder: false,
                bordercolor: '#d9d9d9',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                padding: '10px',
                margin: '10px',
              },
            },
            {
              key: '980b31d540364ae6b1829b91571c6714',
              field: '',
              label: '',
              type: 'grid',
              colProps: { span: 24 },
              component: 'Grid',
              children: [
                {
                  span: 8,
                  list: [
                    {
                      key: 'dc6f609189394b79b231523655452daa',
                      field: 'clbh',
                      label: '车辆编号',
                      type: 'input',
                      component: 'Input',
                      colProps: { span: 24 },
                      defaultValue: '',
                      componentProps: {
                        width: '100%',
                        span: 7,
                        defaultValue: '',
                        placeholder: '请输入车辆编号',
                        prefix: '',
                        suffix: '',
                        addonBefore: '',
                        addonAfter: '',
                        disabled: false,
                        allowClear: false,
                        showLabel: true,
                        required: false,
                        rules: [],
                        events: {},
                        listStyle: '',
                        isSave: false,
                        isShow: true,
                        scan: false,
                        bordered: true,
                        isShowAi: false,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        style: { width: '100%' },
                      },
                    },
                  ],
                },
                {
                  span: 8,
                  list: [
                    {
                      key: '069634cbcf7b4eb99dd167a91f9c4028',
                      field: 'cpxh',
                      label: '厂牌型号',
                      type: 'input',
                      component: 'Input',
                      colProps: { span: 24 },
                      defaultValue: '',
                      componentProps: {
                        width: '100%',
                        span: 7,
                        defaultValue: '',
                        placeholder: '请输入厂牌型号',
                        prefix: '',
                        suffix: '',
                        addonBefore: '',
                        addonAfter: '',
                        disabled: false,
                        allowClear: false,
                        showLabel: true,
                        required: false,
                        rules: [],
                        events: {},
                        listStyle: '',
                        isSave: false,
                        isShow: true,
                        scan: false,
                        bordered: true,
                        isShowAi: false,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        style: { width: '100%' },
                      },
                    },
                  ],
                },
                {
                  span: 8,
                  list: [
                    {
                      key: '4861266b93634eecabc22c20df57f1e5',
                      field: 'cjh',
                      label: '车架号',
                      type: 'input',
                      component: 'Input',
                      colProps: { span: 24 },
                      defaultValue: '',
                      componentProps: {
                        width: '100%',
                        span: 7,
                        defaultValue: '',
                        placeholder: '请输入车架号',
                        prefix: '',
                        suffix: '',
                        addonBefore: '',
                        addonAfter: '',
                        disabled: false,
                        allowClear: false,
                        showLabel: true,
                        required: false,
                        rules: [],
                        events: {},
                        listStyle: '',
                        isSave: false,
                        isShow: true,
                        scan: false,
                        bordered: true,
                        isShowAi: false,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        style: { width: '100%' },
                      },
                    },
                  ],
                },
              ],
              componentProps: {
                gutter: 16,
                justify: 'start',
                align: 'top',
                isShow: true,
                showBorder: false,
                bordercolor: '#d9d9d9',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                padding: '10px',
                margin: '10px',
              },
            },
            {
              key: '04f22a6e421b4bdab5d967b7d9accb76',
              field: '',
              label: '',
              type: 'grid',
              colProps: { span: 24 },
              component: 'Grid',
              children: [
                {
                  span: 8,
                  list: [
                    {
                      key: 'ce1146f2655e4478a755f51dd14860ab',
                      field: 'gbzl',
                      label: '过磅重量(t)',
                      type: 'number',
                      component: 'InputNumber',
                      colProps: { span: 24 },
                      defaultValue: '',
                      componentProps: {
                        width: '100%',
                        span: 7,
                        defaultValue: '',
                        min: 0,
                        max: 1000,
                        step: 1,
                        disabled: false,
                        showLabel: true,
                        controls: true,
                        required: false,
                        subTotal: false,
                        isShow: true,
                        rules: [],
                        events: {},
                        placeholder: '请输入过磅重量(t)',
                        tooltipConfig: { visible: false, title: '提示文本' },
                        style: { width: '100%' },
                      },
                    },
                  ],
                },
                {
                  span: 8,
                  list: [
                    {
                      key: '52100632055d4a86afa6abf9b6519545',
                      field: 'cksj',
                      label: '出库时间',
                      type: 'date',
                      component: 'DatePicker',
                      colProps: { span: 24 },
                      defaultValue: '',
                      componentProps: {
                        span: 7,
                        defaultValue: '',
                        width: '100%',
                        placeholder: '请选择出库时间',
                        format: 'YYYY-MM-DD HH:mm:ss',
                        showLabel: true,
                        allowClear: true,
                        disabled: false,
                        required: false,
                        isShow: true,
                        rules: [],
                        events: {},
                        isGetCurrent: false,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        searchType: 'time',
                        style: { width: '100%' },
                      },
                    },
                  ],
                },
                {
                  span: 8,
                  list: [
                    {
                      key: 'b1f8a7b985a649fcb1622be08e18f5e0',
                      field: 'jcdj',
                      label: '精拆登记',
                      type: 'radio',
                      component: 'ApiRadioGroup',
                      colProps: { span: 24 },
                      componentProps: {
                        span: 7,
                        showLabel: true,
                        disabled: false,
                        optionType: 'default',
                        staticOptions: [
                          { key: 1, label: 'option 1', value: 'option 1' },
                          { key: 2, label: 'option 2', value: 'option 2' },
                          { key: 3, label: 'option 3', value: 'option 3' },
                        ],
                        datasourceType: 'dic',
                        labelField: 'name',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        params: { itemId: '2018139782334705666' },
                        itemId: '2018139782334705666',
                        style: {},
                      },
                    },
                  ],
                },
              ],
              componentProps: {
                gutter: 16,
                justify: 'start',
                align: 'top',
                isShow: true,
                showBorder: false,
                bordercolor: '#d9d9d9',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                padding: '10px',
                margin: '10px',
              },
            },
            {
              key: '7c7d5f418df542f5a1b335a0a693ced1',
              field: '',
              label: '',
              type: 'grid',
              colProps: { span: 24 },
              component: 'Grid',
              children: [
                {
                  span: 8,
                  list: [
                    {
                      key: '41fe600e188a419e8f81a0d2237b9c6b',
                      field: 'ypy',
                      label: '已排液',
                      type: 'radio',
                      component: 'ApiRadioGroup',
                      colProps: { span: 24 },
                      componentProps: {
                        span: 7,
                        showLabel: true,
                        disabled: false,
                        optionType: 'default',
                        staticOptions: [
                          { key: 1, label: 'option 1', value: 'option 1' },
                          { key: 2, label: 'option 2', value: 'option 2' },
                          { key: 3, label: 'option 3', value: 'option 3' },
                        ],
                        datasourceType: 'dic',
                        labelField: 'name',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        params: { itemId: '2018146494923980802' },
                        itemId: '2018146494923980802',
                        style: {},
                      },
                    },
                  ],
                },
                {
                  span: 8,
                  list: [
                    {
                      key: 'e817cfb5fcb94e6498b8420f93633188',
                      field: 'wfcl',
                      label: '已危废处理',
                      type: 'radio',
                      component: 'ApiRadioGroup',
                      colProps: { span: 24 },
                      componentProps: {
                        span: 7,
                        showLabel: true,
                        disabled: false,
                        optionType: 'default',
                        staticOptions: [
                          { key: 1, label: 'option 1', value: 'option 1' },
                          { key: 2, label: 'option 2', value: 'option 2' },
                          { key: 3, label: 'option 3', value: 'option 3' },
                        ],
                        datasourceType: 'dic',
                        labelField: 'name',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        params: { itemId: '2018146494923980802' },
                        itemId: '2018146494923980802',
                        style: {},
                      },
                    },
                  ],
                },
                {
                  span: 8,
                  list: [
                    {
                      key: 'c650357ddb43498186d3e450c4dc9b96',
                      field: 'ypybg',
                      label: '已排液报工',
                      type: 'radio',
                      component: 'ApiRadioGroup',
                      colProps: { span: 24 },
                      componentProps: {
                        span: 7,
                        showLabel: true,
                        disabled: false,
                        optionType: 'default',
                        staticOptions: [
                          { key: 1, label: 'option 1', value: 'option 1' },
                          { key: 2, label: 'option 2', value: 'option 2' },
                          { key: 3, label: 'option 3', value: 'option 3' },
                        ],
                        datasourceType: 'dic',
                        labelField: 'name',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        params: { itemId: '2018146494923980802' },
                        itemId: '2018146494923980802',
                        style: {},
                      },
                    },
                  ],
                },
              ],
              componentProps: {
                gutter: 16,
                justify: 'start',
                align: 'top',
                isShow: true,
                showBorder: false,
                bordercolor: '#d9d9d9',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                padding: '10px',
                margin: '10px',
              },
            },
            {
              key: '9f4599ff93b64b50a578c3fc1cda84eb',
              field: '',
              label: '',
              type: 'grid',
              colProps: { span: 24 },
              component: 'Grid',
              children: [
                {
                  span: 8,
                  list: [
                    {
                      key: '1fa401aa7d4a4c8db3756c363332df17',
                      field: 'sfcj',
                      label: '已拆解',
                      type: 'radio',
                      component: 'ApiRadioGroup',
                      colProps: { span: 24 },
                      componentProps: {
                        span: 7,
                        showLabel: true,
                        disabled: false,
                        optionType: 'default',
                        staticOptions: [
                          { key: 1, label: 'option 1', value: 'option 1' },
                          { key: 2, label: 'option 2', value: 'option 2' },
                          { key: 3, label: 'option 3', value: 'option 3' },
                        ],
                        datasourceType: 'dic',
                        labelField: 'name',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        params: { itemId: '2018146494923980802' },
                        itemId: '2018146494923980802',
                        style: {},
                      },
                    },
                  ],
                },
                { span: 8, list: [] },
                { span: 8, list: [] },
              ],
              componentProps: {
                gutter: 16,
                justify: 'start',
                align: 'top',
                isShow: true,
                showBorder: false,
                bordercolor: '#d9d9d9',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                padding: '10px',
                margin: '10px',
              },
            },
            {
              key: '8b98de2c8ee94a559e97b7a617a819b3',
              field: 'bz',
              label: '备注',
              type: 'textarea',
              component: 'InputTextArea',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: '',
                defaultValue: '',
                placeholder: '请输入备注',
                rows: 4,
                autoSize: false,
                showCount: false,
                disabled: false,
                showLabel: true,
                allowClear: false,
                required: false,
                isShow: true,
                isShowAi: false,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        title: '基本信息',
        isShow: true,
        cardStyle: {
          border: { isShow: false, color: '#ffffff', width: '1' },
          title: { isShow: true, color: '#1c8dff', fontSize: '14', fontWeight: '800' },
          background: { isShow: false, bgColor: '#ffffff', bgImgUrl: '', bgRepeat: 'no-repeat' },
          content: { isShow: false, bgColor: '#ffffff', bgImgUrl: '', bgRepeat: 'no-repeat' },
          divider: { isShow: true, color: '#eeeeee', width: '1' },
          icon: { isShow: true, color: '#cbcfd5' },
        },
      },
    },
    {
      key: '4c8acee426544dee9770ed8f8d3124e1',
      field: '',
      label: '',
      type: 'card',
      colProps: { span: 24 },
      component: 'Card',
      children: [
        {
          span: 24,
          name: 'card',
          list: [
            {
              key: '88359c4064dd486d8e2e830cac4d3ac8',
              field: '',
              label: '',
              type: 'grid',
              colProps: { span: 24 },
              component: 'Grid',
              children: [
                {
                  span: 12,
                  list: [
                    {
                      key: '20998e26a46b4887969a51f901179916',
                      field: 'qcy',
                      label: '汽/柴油',
                      type: 'radio',
                      component: 'ApiRadioGroup',
                      colProps: { span: 24 },
                      componentProps: {
                        span: 7,
                        showLabel: true,
                        disabled: false,
                        optionType: 'default',
                        staticOptions: [
                          { key: 1, label: 'option 1', value: 'option 1' },
                          { key: 2, label: 'option 2', value: 'option 2' },
                          { key: 3, label: 'option 3', value: 'option 3' },
                        ],
                        datasourceType: 'dic',
                        labelField: 'name',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        params: { itemId: '2018195723193282562' },
                        itemId: '2018195723193282562',
                        style: {},
                      },
                    },
                  ],
                },
                {
                  span: 12,
                  list: [
                    {
                      key: '51b785daa6614711a6f7b5ca2923a6c3',
                      field: 'bls',
                      label: '玻璃水',
                      type: 'radio',
                      component: 'ApiRadioGroup',
                      colProps: { span: 24 },
                      componentProps: {
                        span: 7,
                        showLabel: true,
                        disabled: false,
                        optionType: 'default',
                        staticOptions: [
                          { key: 1, label: 'option 1', value: 'option 1' },
                          { key: 2, label: 'option 2', value: 'option 2' },
                          { key: 3, label: 'option 3', value: 'option 3' },
                        ],
                        datasourceType: 'dic',
                        labelField: 'name',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        params: { itemId: '2018195723193282562' },
                        itemId: '2018195723193282562',
                        style: {},
                      },
                    },
                  ],
                },
              ],
              componentProps: {
                gutter: 16,
                justify: 'start',
                align: 'top',
                isShow: true,
                showBorder: false,
                bordercolor: '#d9d9d9',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                padding: '10px',
                margin: '10px',
              },
            },
            {
              key: 'bf0875475baf4c3cb18b93f602456d2b',
              field: '',
              label: '',
              type: 'grid',
              colProps: { span: 24 },
              component: 'Grid',
              children: [
                {
                  span: 12,
                  list: [
                    {
                      key: '694d57edc5ef495e874f4e8d33a0178c',
                      field: 'jy',
                      label: '机油',
                      type: 'radio',
                      component: 'ApiRadioGroup',
                      colProps: { span: 24 },
                      componentProps: {
                        span: 7,
                        showLabel: true,
                        disabled: false,
                        optionType: 'default',
                        staticOptions: [
                          { key: 1, label: 'option 1', value: 'option 1' },
                          { key: 2, label: 'option 2', value: 'option 2' },
                          { key: 3, label: 'option 3', value: 'option 3' },
                        ],
                        datasourceType: 'dic',
                        labelField: 'name',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        params: { itemId: '2018195723193282562' },
                        itemId: '2018195723193282562',
                        style: {},
                      },
                    },
                  ],
                },
                {
                  span: 12,
                  list: [
                    {
                      key: 'e261c77e317c4c62b8ce298b87e5233d',
                      field: 'zdy',
                      label: '制动液',
                      type: 'radio',
                      component: 'ApiRadioGroup',
                      colProps: { span: 24 },
                      componentProps: {
                        span: 7,
                        showLabel: true,
                        disabled: false,
                        optionType: 'default',
                        staticOptions: [
                          { key: 1, label: 'option 1', value: 'option 1' },
                          { key: 2, label: 'option 2', value: 'option 2' },
                          { key: 3, label: 'option 3', value: 'option 3' },
                        ],
                        datasourceType: 'dic',
                        labelField: 'name',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        params: { itemId: '2018195723193282562' },
                        itemId: '2018195723193282562',
                        style: {},
                      },
                    },
                  ],
                },
              ],
              componentProps: {
                gutter: 16,
                justify: 'start',
                align: 'top',
                isShow: true,
                showBorder: false,
                bordercolor: '#d9d9d9',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                padding: '10px',
                margin: '10px',
              },
            },
            {
              key: '9aea19c08ae24e3ea9aa3c402f395cf1',
              field: '',
              label: '',
              type: 'grid',
              colProps: { span: 24 },
              component: 'Grid',
              children: [
                {
                  span: 12,
                  list: [
                    {
                      key: '4da5b53d257b46f8b4689da3e0822462',
                      field: 'bsxy',
                      label: '变速箱油',
                      type: 'radio',
                      component: 'ApiRadioGroup',
                      colProps: { span: 24 },
                      componentProps: {
                        span: 7,
                        showLabel: true,
                        disabled: false,
                        optionType: 'default',
                        staticOptions: [
                          { key: 1, label: 'option 1', value: 'option 1' },
                          { key: 2, label: 'option 2', value: 'option 2' },
                          { key: 3, label: 'option 3', value: 'option 3' },
                        ],
                        datasourceType: 'dic',
                        labelField: 'name',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        params: { itemId: '2018195723193282562' },
                        itemId: '2018195723193282562',
                        style: {},
                      },
                    },
                  ],
                },
                {
                  span: 12,
                  list: [
                    {
                      key: 'b1eae4ad0ad8403ba401150f170f9be4',
                      field: 'ns',
                      label: '尿素',
                      type: 'radio',
                      component: 'ApiRadioGroup',
                      colProps: { span: 24 },
                      componentProps: {
                        span: 7,
                        showLabel: true,
                        disabled: false,
                        optionType: 'default',
                        staticOptions: [
                          { key: 1, label: 'option 1', value: 'option 1' },
                          { key: 2, label: 'option 2', value: 'option 2' },
                          { key: 3, label: 'option 3', value: 'option 3' },
                        ],
                        datasourceType: 'dic',
                        labelField: 'name',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        params: { itemId: '2018195723193282562' },
                        itemId: '2018195723193282562',
                        style: {},
                      },
                    },
                  ],
                },
              ],
              componentProps: {
                gutter: 16,
                justify: 'start',
                align: 'top',
                isShow: true,
                showBorder: false,
                bordercolor: '#d9d9d9',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                padding: '10px',
                margin: '10px',
              },
            },
            {
              key: '6a86913af746481696586f96c2b9d6d2',
              field: '',
              label: '',
              type: 'grid',
              colProps: { span: 24 },
              component: 'Grid',
              children: [
                {
                  span: 12,
                  list: [
                    {
                      key: '80704cb0a1194d2c97af6cd55fadc3eb',
                      field: 'yyy',
                      label: '液压油',
                      type: 'radio',
                      component: 'ApiRadioGroup',
                      colProps: { span: 24 },
                      componentProps: {
                        span: 7,
                        showLabel: true,
                        disabled: false,
                        optionType: 'default',
                        staticOptions: [
                          { key: 1, label: 'option 1', value: 'option 1' },
                          { key: 2, label: 'option 2', value: 'option 2' },
                          { key: 3, label: 'option 3', value: 'option 3' },
                        ],
                        datasourceType: 'dic',
                        labelField: 'name',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        params: { itemId: '2018195723193282562' },
                        itemId: '2018195723193282562',
                        style: {},
                      },
                    },
                  ],
                },
                {
                  span: 12,
                  list: [
                    {
                      key: 'e034a7eea71e45a29255529bdcae050c',
                      field: 'zly',
                      label: '制冷液',
                      type: 'radio',
                      component: 'ApiRadioGroup',
                      colProps: { span: 24 },
                      componentProps: {
                        span: 7,
                        showLabel: true,
                        disabled: false,
                        optionType: 'default',
                        staticOptions: [
                          { key: 1, label: 'option 1', value: 'option 1' },
                          { key: 2, label: 'option 2', value: 'option 2' },
                          { key: 3, label: 'option 3', value: 'option 3' },
                        ],
                        datasourceType: 'dic',
                        labelField: 'name',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        params: { itemId: '2018195723193282562' },
                        itemId: '2018195723193282562',
                        style: {},
                      },
                    },
                  ],
                },
              ],
              componentProps: {
                gutter: 16,
                justify: 'start',
                align: 'top',
                isShow: true,
                showBorder: false,
                bordercolor: '#d9d9d9',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                padding: '10px',
                margin: '10px',
              },
            },
            {
              key: '191c4b1b3767402595dea9694be5534e',
              field: '',
              label: '',
              type: 'grid',
              colProps: { span: 24 },
              component: 'Grid',
              children: [
                {
                  span: 12,
                  list: [
                    {
                      key: 'd5acf49953f44859914119e1ad097063',
                      field: 'fdy',
                      label: '防冻液',
                      type: 'radio',
                      component: 'ApiRadioGroup',
                      colProps: { span: 24 },
                      componentProps: {
                        span: 7,
                        showLabel: true,
                        disabled: false,
                        optionType: 'default',
                        staticOptions: [
                          { key: 1, label: 'option 1', value: 'option 1' },
                          { key: 2, label: 'option 2', value: 'option 2' },
                          { key: 3, label: 'option 3', value: 'option 3' },
                        ],
                        datasourceType: 'dic',
                        labelField: 'name',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        params: { itemId: '2018195723193282562' },
                        itemId: '2018195723193282562',
                        style: {},
                      },
                    },
                  ],
                },
                {
                  span: 12,
                  list: [
                    {
                      key: '19c1a2df12aa477aa7a9424a1aee1f4d',
                      field: 'qtfyy',
                      label: '其他废油液',
                      type: 'radio',
                      component: 'ApiRadioGroup',
                      colProps: { span: 24 },
                      componentProps: {
                        span: 7,
                        showLabel: true,
                        disabled: false,
                        optionType: 'default',
                        staticOptions: [
                          { key: 1, label: 'option 1', value: 'option 1' },
                          { key: 2, label: 'option 2', value: 'option 2' },
                          { key: 3, label: 'option 3', value: 'option 3' },
                        ],
                        datasourceType: 'dic',
                        labelField: 'name',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        params: { itemId: '2018195723193282562' },
                        itemId: '2018195723193282562',
                        style: {},
                      },
                    },
                  ],
                },
              ],
              componentProps: {
                gutter: 16,
                justify: 'start',
                align: 'top',
                isShow: true,
                showBorder: false,
                bordercolor: '#d9d9d9',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                padding: '10px',
                margin: '10px',
              },
            },
          ],
        },
      ],
      componentProps: {
        title: '排液信息',
        isShow: true,
        cardStyle: {
          border: { isShow: false, color: '#ffffff', width: '1' },
          title: { isShow: true, color: '#1c8dff', fontSize: '14', fontWeight: '800' },
          background: { isShow: false, bgColor: '#ffffff', bgImgUrl: '', bgRepeat: 'no-repeat' },
          content: { isShow: false, bgColor: '#ffffff', bgImgUrl: '', bgRepeat: 'no-repeat' },
          divider: { isShow: true, color: '#eeeeee', width: '1' },
          icon: { isShow: true, color: '#cbcfd5' },
        },
      },
    },
    {
      key: 'ecc7afd25fe94a5ca5d89299f7e959b3',
      field: '',
      label: '',
      type: 'card',
      colProps: { span: 24 },
      component: 'Card',
      children: [
        {
          span: 24,
          name: 'card',
          list: [
            {
              key: '52ac25d4387a42e39a3a01150f92c429',
              field: '',
              label: '',
              type: 'grid',
              colProps: { span: 24 },
              component: 'Grid',
              children: [
                {
                  span: 12,
                  list: [
                    {
                      key: '72e006508bf643d793670c60f095e41f',
                      field: 'sych',
                      label: '三元催化',
                      type: 'radio',
                      component: 'ApiRadioGroup',
                      colProps: { span: 24 },
                      componentProps: {
                        span: 7,
                        showLabel: true,
                        disabled: false,
                        optionType: 'default',
                        staticOptions: [
                          { key: 1, label: 'option 1', value: 'option 1' },
                          { key: 2, label: 'option 2', value: 'option 2' },
                          { key: 3, label: 'option 3', value: 'option 3' },
                        ],
                        datasourceType: 'dic',
                        labelField: 'name',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        params: { itemId: '2018198348978581506' },
                        itemId: '2018198348978581506',
                        style: {},
                      },
                    },
                  ],
                },
                {
                  span: 12,
                  list: [
                    {
                      key: '87e731c99df842b68550e75d88dbc47e',
                      field: 'cllt',
                      label: '轮胎',
                      type: 'radio',
                      component: 'ApiRadioGroup',
                      colProps: { span: 24 },
                      componentProps: {
                        span: 7,
                        showLabel: true,
                        disabled: false,
                        optionType: 'default',
                        staticOptions: [
                          { key: 1, label: 'option 1', value: 'option 1' },
                          { key: 2, label: 'option 2', value: 'option 2' },
                          { key: 3, label: 'option 3', value: 'option 3' },
                        ],
                        datasourceType: 'dic',
                        labelField: 'name',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        params: { itemId: '2018198348978581506' },
                        itemId: '2018198348978581506',
                        style: {},
                      },
                    },
                  ],
                },
              ],
              componentProps: {
                gutter: 16,
                justify: 'start',
                align: 'top',
                isShow: true,
                showBorder: false,
                bordercolor: '#d9d9d9',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                padding: '10px',
                margin: '10px',
              },
            },
            {
              key: '7a00979433cc40259ac0d8ca21753468',
              field: '',
              label: '',
              type: 'grid',
              colProps: { span: 24 },
              component: 'Grid',
              children: [
                {
                  span: 12,
                  list: [
                    {
                      key: '39b9c90a2b214d3bab1904b118424bad',
                      field: 'aqqn',
                      label: '安全气囊',
                      type: 'radio',
                      component: 'ApiRadioGroup',
                      colProps: { span: 24 },
                      componentProps: {
                        span: 7,
                        showLabel: true,
                        disabled: false,
                        optionType: 'default',
                        staticOptions: [
                          { key: 1, label: 'option 1', value: 'option 1' },
                          { key: 2, label: 'option 2', value: 'option 2' },
                          { key: 3, label: 'option 3', value: 'option 3' },
                        ],
                        datasourceType: 'dic',
                        labelField: 'name',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        params: { itemId: '2018198644240805889' },
                        itemId: '2018198644240805889',
                        style: {},
                      },
                    },
                  ],
                },
                {
                  span: 12,
                  list: [
                    {
                      key: '9cbd10bbcb9d4ef2be721112b292f1fd',
                      field: 'dp',
                      label: '电瓶',
                      type: 'radio',
                      component: 'ApiRadioGroup',
                      colProps: { span: 24 },
                      componentProps: {
                        span: 7,
                        showLabel: true,
                        disabled: false,
                        optionType: 'default',
                        staticOptions: [
                          { key: 1, label: 'option 1', value: 'option 1' },
                          { key: 2, label: 'option 2', value: 'option 2' },
                          { key: 3, label: 'option 3', value: 'option 3' },
                        ],
                        datasourceType: 'dic',
                        labelField: 'name',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        params: { itemId: '2018198644240805889' },
                        itemId: '2018198644240805889',
                        style: {},
                      },
                    },
                  ],
                },
              ],
              componentProps: {
                gutter: 16,
                justify: 'start',
                align: 'top',
                isShow: true,
                showBorder: false,
                bordercolor: '#d9d9d9',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                padding: '10px',
                margin: '10px',
              },
            },
          ],
        },
      ],
      componentProps: {
        title: '危废拆解',
        isShow: true,
        cardStyle: {
          border: { isShow: false, color: '#000999', width: '1' },
          title: { isShow: true, color: '#1c8dff', fontSize: '14', fontWeight: '800' },
          background: { isShow: false, bgColor: '#ffffff', bgImgUrl: '', bgRepeat: 'no-repeat' },
          content: { isShow: false, bgColor: '#ffffff', bgImgUrl: '', bgRepeat: 'no-repeat' },
          divider: { isShow: true, color: '#eeeeee', width: '1' },
          icon: { isShow: true, color: '#cbcfd5' },
        },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
