
import { MesQualityTypePageModel, MesQualityTypePageParams, MesQualityTypePageResult } from './model/ZjxmlbModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/zlgl/zjxmlb/page',
  List = '/zlgl/zjxmlb/list',
  Info = '/zlgl/zjxmlb/info',
  MesQualityType = '/zlgl/zjxmlb',
}

/**
 * @description: 查询MesQualityType分页列表
 */
export async function getMesQualityTypePage(params: MesQualityTypePageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQualityTypePageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesQualityType信息
 */
export async function getMesQualityType(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQualityTypePageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesQualityType
 */
export async function addMesQualityType(mesQualityType: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesQualityType,
      params: mesQualityType,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesQualityType
 */
export async function updateMesQualityType(mesQualityType: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesQualityType,
      params: mesQualityType,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesQualityType（批量删除）
 */
export async function deleteMesQualityType(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesQualityType,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




