
import { MesDeQualityInspectionPageModel, MesDeQualityInspectionPageParams, MesDeQualityInspectionPageResult } from './model/CgzjdModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/zlgl/cgzjd/page',
  List = '/zlgl/cgzjd/list',
  Info = '/zlgl/cgzjd/info',
  MesDeQualityInspection = '/zlgl/cgzjd',
  
  
  
}

/**
 * @description: 查询MesDeQualityInspection分页列表
 */
export async function getMesDeQualityInspectionPage(params: MesDeQualityInspectionPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesDeQualityInspectionPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesDeQualityInspection信息
 */
export async function getMesDeQualityInspection(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesDeQualityInspectionPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesDeQualityInspection
 */
export async function addMesDeQualityInspection(mesDeQualityInspection: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesDeQualityInspection,
      params: mesDeQualityInspection,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesDeQualityInspection
 */
export async function updateMesDeQualityInspection(mesDeQualityInspection: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesDeQualityInspection,
      params: mesDeQualityInspection,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesDeQualityInspection（批量删除）
 */
export async function deleteMesDeQualityInspection(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesDeQualityInspection,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




