
import { MesQualityUnqualifiedPageModel, MesQualityUnqualifiedPageParams, MesQualityUnqualifiedPageResult } from './model/BhgpclModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/zlgl/bhgpcl/page',
  List = '/zlgl/bhgpcl/list',
  Info = '/zlgl/bhgpcl/info',
  MesQualityUnqualified = '/zlgl/bhgpcl',
  
  
  Export = '/zlgl/bhgpcl/export',
  
  ListChildren = '/zlgl/bhgpcl/list-children'
}

/**
 * @description: 查询MesQualityUnqualified分页列表
 */
export async function getMesQualityUnqualifiedPage(params: MesQualityUnqualifiedPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQualityUnqualifiedPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesQualityUnqualified信息
 */
export async function getMesQualityUnqualified(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQualityUnqualifiedPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesQualityUnqualified
 */
export async function addMesQualityUnqualified(mesQualityUnqualified: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesQualityUnqualified,
      params: mesQualityUnqualified,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesQualityUnqualified
 */
export async function updateMesQualityUnqualified(mesQualityUnqualified: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesQualityUnqualified,
      params: mesQualityUnqualified,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesQualityUnqualified（批量删除）
 */
export async function deleteMesQualityUnqualified(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesQualityUnqualified,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}



/**
 * @description: 导出MesQualityUnqualified
 */
export async function exportMesQualityUnqualified(
  params?: object, 
  mode: ErrorMessageMode = 'modal'
) {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
  

/**
 * @description: 查询子表数据
 */
export async function getChildrenMesQualityUnqualified(params: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.ListChildren,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}
