
import { MesSystemParamPageModel, MesSystemParamPageParams, MesSystemParamPageResult } from './model/SystemParamModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/system/systemparam/page',
  List = '/system/systemparam/list',
  Info = '/system/systemparam/info',
  MesSystemParam = '/system/systemparam',
  
  
  
}

/**
 * @description: 查询MesSystemParam分页列表
 */
export async function getMesSystemParamPage(params: MesSystemParamPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesSystemParamPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesSystemParam信息
 */
export async function getMesSystemParam(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesSystemParamPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesSystemParam
 */
export async function addMesSystemParam(mesSystemParam: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesSystemParam,
      params: mesSystemParam,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesSystemParam
 */
export async function updateMesSystemParam(mesSystemParam: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesSystemParam,
      params: mesSystemParam,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesSystemParam（批量删除）
 */
export async function deleteMesSystemParam(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesSystemParam,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




