import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';
import { CodePageListSearchModel, CodeResultModel, CodeNameParamsModel } from './model';

enum Api {
  Page = '/system/regular-expression/page',
  List = '/system/regular-expression/list',
  RuleCode = '/system/regular-expression',
  Info = '/system/regular-expression/info',
}

/**
 * @description: 查询正则表达式（分页）
 */
export async function getRuleCodePageList(
  params?: CodePageListSearchModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<CodeResultModel[]>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 查询所有正则表达式 （不分页）
 */
export async function getRegularListAll(mode: ErrorMessageMode = 'modal') {
  return defHttp.get<CodeResultModel[]>(
    {
      url: Api.List,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除正则表达式（批量删除）
 */
export async function deleteRuleCode(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<number>(
    {
      url: Api.RuleCode,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 修改正则表达式
 */
export async function updateRuleCode(data: CodeNameParamsModel, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<number>(
    {
      url: Api.RuleCode,
      data,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取正则表达式详情
 */
export async function getRuleCodeInfo(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<CodeNameParamsModel[]>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增正则表达式
 */
export async function addRuleCode(data: CodeNameParamsModel, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<number>(
    {
      url: Api.RuleCode,
      data,
    },
    {
      errorMessageMode: mode,
    },
  );
}
