
import { MesFineReportPageModel, MesFineReportPageParams, MesFineReportPageResult } from './model/FineReportModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/system/finereport/page',
  List = '/system/finereport/list',
  Info = '/system/finereport/info',
  MesFineReport = '/system/finereport',
  GetByCode = '/system/finereport/code',

  
  
}

/**
 * @description: 查询MesFineReport分页列表
 */
export async function getMesFineReportPage(params: MesFineReportPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesFineReportPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesFineReport信息
 */
export async function getMesFineReport(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesFineReportPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 根据模板标识获取MesFineReport信息
 */
export async function getMesFineReportByCode(code: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesFineReportPageModel>(
    {
      url: Api.GetByCode + '/' + code,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesFineReport
 */
export async function addMesFineReport(mesFineReport: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesFineReport,
      params: mesFineReport,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesFineReport
 */
export async function updateMesFineReport(mesFineReport: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesFineReport,
      params: mesFineReport,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesFineReport（批量删除）
 */
export async function deleteMesFineReport(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesFineReport,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




