import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesMoldInfo分页参数 模型
 */
export interface MesMoldInfoPageParams extends BasicPageParams {
  mjbh: string;

  mjxh: string;

  mjzt: string;
}

/**
 * @description: MesMoldInfo分页返回值模型
 */
export interface MesMoldInfoPageModel {
  id: string;

  mjbh: string;

  mjxh: string;

  mjzt: string;

  cszl: string;

  syxc: string;

  sycz: string;
}

/**
 * @description: MesMoldInfo表类型
 */
export interface MesMoldInfoModel {
  id: string;

  deleteMark: string;

  mjbh: string;

  mjxh: string;

  mjzt: string;

  syxc: string;

  sycz: string;

  sssm: string;

  gycs: string;

  cszl: string;

  ysbg: string;

  smzqlx: string;

  bzsmzq: string;

  xhsmzq: string;

  sysmzq: string;

  p1: string;

  p2: string;

  p3: string;

  p4: string;

  p5: string;

  p6: string;

  p7: string;

  p8: string;

  p9: string;

  p10: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;

  mesMoldLogGhList?: MesMoldLogGhModel;

  mesMoldLogSxList?: MesMoldLogSxModel;

  mesMoldLogSyList?: MesMoldLogSyModel;

  mesMoldLogWxList?: MesMoldLogWxModel;

  mesMoldLogLyList?: MesMoldLogLyModel;
}

/**
 * @description: MesMoldLogGh表类型
 */
export interface MesMoldLogGhModel {
  rzid: string;

  deleteMark: string;

  mjid: string;

  ghdh: string;

  ghr: string;

  ghsl: string;

  ghsj: string;

  ghzt: string;

  p1: string;

  p2: string;

  p3: string;

  p4: string;

  p5: string;

  p6: string;

  p7: string;

  p8: string;

  p9: string;

  p10: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;
}

/**
 * @description: MesMoldLogSx表类型
 */
export interface MesMoldLogSxModel {
  rzid: string;

  deleteMark: string;

  mjid: string;

  sxdh: string;

  sxr: string;

  sxsj: string;

  sxsm: string;

  p1: string;

  p2: string;

  p3: string;

  p4: string;

  p5: string;

  p6: string;

  p7: string;

  p8: string;

  p9: string;

  p10: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;

  sxqzl: string;

  sxhzl: string;

  sxcwzl: string;
}

/**
 * @description: MesMoldLogSy表类型
 */
export interface MesMoldLogSyModel {
  rzid: string;

  deleteMark: string;

  mjid: string;

  sydh: string;

  syr: string;

  sysb: string;

  xhsmyz: string;

  syfs: string;

  sysj: string;

  sysm: string;

  p1: string;

  p2: string;

  p3: string;

  p4: string;

  p5: string;

  p6: string;

  p7: string;

  p8: string;

  p9: string;

  p10: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;
}

/**
 * @description: MesMoldLogWx表类型
 */
export interface MesMoldLogWxModel {
  rzid: string;

  deleteMark: string;

  mjid: string;

  bxdh: string;

  bxr: string;

  bxsj: string;

  gzms: string;

  zpr: string;

  wxr: string;

  wxzt: string;

  wxsj: string;

  wxjg: string;

  p1: string;

  p2: string;

  p3: string;

  p4: string;

  p5: string;

  p6: string;

  p7: string;

  p8: string;

  p9: string;

  p10: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;
}

/**
 * @description: MesMoldLogLy表类型
 */
export interface MesMoldLogLyModel {
  rzid: string;

  deleteMark: string;

  mjid: string;

  lydh: string;

  lyr: string;

  lysl: string;

  lysj: string;

  lyjjr: string;

  lybm: string;

  lysm: string;

  lyzt: string;

  p1: string;

  p2: string;

  p3: string;

  p4: string;

  p5: string;

  p6: string;

  p7: string;

  p8: string;

  p9: string;

  p10: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;
}

/**
 * @description: MesMoldInfo分页返回值结构
 */
export type MesMoldInfoPageResult = BasicFetchResult<MesMoldInfoPageModel>;
