import {
  MesWarehouseCheckModel,
  MesWarehouseCheckPageParams,
  MesWarehouseCheckPageResult,
} from './model/WarehouseCheckModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/warehousecheck/page',
  List = '/mes/warehousecheck/list',
  Info = '/mes/warehousecheck/info',
  MesWarehouseCheck = '/mes/warehousecheck',

  Export = '/mes/warehousecheck/export',
}

/**
 * @description: 查询MesWarehouseCheck分页列表
 */
export async function getMesWarehouseCheckPage(
  params: MesWarehouseCheckPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesWarehouseCheckPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesWarehouseCheck信息
 */
export async function getMesWarehouseCheck(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseCheckModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesWarehouseCheck
 */
export async function addMesWarehouseCheck(
  mesWarehouseCheck: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: Api.MesWarehouseCheck,
      params: mesWarehouseCheck,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesWarehouseCheck
 */
export async function updateMesWarehouseCheck(
  mesWarehouseCheck: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.MesWarehouseCheck,
      params: mesWarehouseCheck,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesWarehouseCheck（批量删除）
 */
export async function deleteMesWarehouseCheck(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesWarehouseCheck,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 导出MesWarehouseCheck
 */
export async function exportMesWarehouseCheck(params?: object, mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}

export async function finishMesWarehouseCheck(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: '/mes/warehousecheck/finish/' + id,
    },
    {
      errorMessageMode: mode,
    },
  );
}
