import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesProcess分页参数 模型
 */
export interface MesProcessPageParams extends BasicPageParams {
  processCode: string;

  processName: string;

  processType: string;

  createUserId: string;

  createDateStart: string;
  createDateEnd: string;
}

/**
 * @description: MesProcess分页返回值模型
 */
export interface MesProcessPageModel {
  id: string;

  processCode: string;

  processName: string;

  processType: string;

  remark: string;

  createUserId: string;

  createDate: string;
}

/**
 * @description: MesProcess表类型
 */
export interface MesProcessModel {
  id: number;

  isSysNum: string;

  processCode: string;

  processName: string;

  processType: string;

  imgFile: string;

  standardHour: string;

  auxiliaryHour: string;

  processCost: string;

  processPrice: string;

  stationIds: string;

  materialIds: string;

  state: number;

  sort: number;

  remark: string;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;

  mesProcessMaterialList?: MesProcessMaterialModel;

  mesProcessParamList?: MesProcessParamModel;

  mesProcessStationList?: MesProcessStationModel;
}

/**
 * @description: MesProcessMaterial表类型
 */
export interface MesProcessMaterialModel {
  id: number;

  processId: string;

  materialId: string;

  materialCode: string;

  materialName: string;

  materialType: string;

  materialAttr: string;

  unity: string;

  state: number;

  sort: number;

  remark: string;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesProcessParam表类型
 */
export interface MesProcessParamModel {
  id: number;

  processId: string;

  paramName: string;

  paramValue: string;

  state: number;

  sort: number;

  remark: string;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesProcessStation表类型
 */
export interface MesProcessStationModel {
  id: number;

  processId: string;

  stationId: string;

  stationCode: string;

  stationName: string;

  lineId: string;

  lineName: string;

  carId: string;

  carName: string;

  factoryId: string;

  factoryName: string;

  state: number;

  sort: number;

  remark: string;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesProcess分页返回值结构
 */
export type MesProcessPageResult = BasicFetchResult<MesProcessPageModel>;
