import { MesQbSemifinErrorModel, MesQbSemifinErrorPageParams, MesQbSemifinErrorPageResult } from './model/MesSemiFinishErrorModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/messemifinisherror/page',
  List = '/mes/messemifinisherror/list',
  Info = '/mes/messemifinisherror/info',
  MesQbSemifinError = '/mes/messemifinisherror',
  
  
}

/**
 * @description: 查询MesQbSemifinError分页列表
 */
export async function getMesQbSemifinErrorPage(params: MesQbSemifinErrorPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQbSemifinErrorPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesQbSemifinError信息
 */
export async function getMesQbSemifinError(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQbSemifinErrorModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesQbSemifinError
 */
export async function addMesQbSemifinError(mesQbSemifinError: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesQbSemifinError,
      params: mesQbSemifinError,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesQbSemifinError
 */
export async function updateMesQbSemifinError(mesQbSemifinError: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesQbSemifinError,
      params: mesQbSemifinError,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesQbSemifinError（批量删除）
 */
export async function deleteMesQbSemifinError(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesQbSemifinError,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}