import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesQpProcessPatrol分页参数 模型
 */
export interface MesQpProcessPatrolPageParams extends BasicPageParams {
  reportNo: string;

  reportName: string;

  checkDate: string;

  carId: string;

  stationId: string;

  checkUser: string;

  state: string;
}

/**
 * @description: MesQpProcessPatrol分页返回值模型
 */
export interface MesQpProcessPatrolPageModel {
  id: string;

  reportNo: string;

  checkDate: string;

  reportName: string;

  carId: string;

  lineId: string;

  stationId: string;

  checkUser: string;

  createUserId: string;

  createDate: string;

  state: string;
}

/**
 * @description: MesQpProcessPatrol表类型
 */
export interface MesQpProcessPatrolModel {
  id: number;

  isSysNum: string;

  reportNo: string;

  reportName: string;

  checkUser: string;

  checkDate: string;

  carId: string;

  lineId: string;

  stationId: string;

  factoryId: string;

  remark: string;

  errorState: string;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;

  mesQpProcessPatroldataList?: MesQpProcessPatroldataModel;
}

/**
 * @description: MesQpProcessPatroldata表类型
 */
export interface MesQpProcessPatroldataModel {
  id: number;

  reportId: number;

  reportNo: string;

  firstId: string;

  firstNo: string;

  saleId: string;

  saleNo: string;

  saleName: string;

  productId: string;

  productCode: string;

  productName: string;

  materialId: string;

  materialNo: string;

  materialName: string;

  checkTime: string;

  checkNum: string;

  checkUnit: string;

  checkType: string;

  checkProduct: string;

  referenceValue: string;

  upTolerance: string;

  downTolerance: string;

  measuredValue: string;

  errorNum: string;

  errorMethod: string;

  imgFile: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesQpProcessPatrol分页返回值结构
 */
export type MesQpProcessPatrolPageResult = BasicFetchResult<MesQpProcessPatrolPageModel>;
