import { defHttp } from '/@/utils/http/axios';

/**翻译下拉框 */
export function getOptionsValueArr(option, value) {
  return getOptionsValue(option, value ? value.join(',') : '');
}
export function getOptionsValue(option, value) {
  let temp = '';
  if (option && value) {
    let valueArr = value.split(',');
    valueArr.forEach((a) => {
      option.forEach((e) => {
        if (e.value == a) {
          if (temp && temp.length > 0) temp += ',';
          temp += e.label;
        }
      });
    });
  }
  return temp ? temp : value;
}

export async function getDicItem(itemId) {
  let temp = await defHttp.get({
    url: '/system/dictionary-detail?itemId=' + itemId,
  });
  if (temp)
    temp.forEach((e) => {
      e.key = e.value;
      e.label = e.name;
    });
  return temp;
}
export async function getAutoCode(code) {
  return defHttp.get({
    url: '/system/code-rule/generate?encode=' + code,
  });
}

/**
 * 检测标准
 */
export async function getMesQbCheckstandardList() {
  return defHttp.get({
    url: '/magic-api/mes/getCheckStandard',
  });
}

/**
 * 检测类别
 */
export async function getMesQbCheckTypeList() {
  return defHttp.get({
    url: '/magic-api/mes/getCheckType',
  });
}

/**
 * 检测项目
 */
export async function getMesQbCheckProductList() {
  return defHttp.get({
    url: '/magic-api/mes/getCheckProduct',
  });
}

/**
 * 检测方法
 */
export async function getMesQbCheckMethodList() {
  return defHttp.get({
    url: '/magic-api/mes/getCheckmethod',
  });
}
/**
 * 查询项目列表
 */
export async function getProductList() {
  return defHttp.get({
    url: '/magic-api/mes/getProductList',
  });
}
/**
 * 仓库信息
 * @param type 类型（0-仓库、1-库区、2-库位）
 * @param parentId
 */
export async function getWarehouseList(type: number, parentId: string) {
  return defHttp.get({
    url: '/magic-api/mes/getWarehouseList?data_type=' + type + '&parent_id=' + parentId,
  });
}

/**
 * 查询所有库区&库位
 */
export async function getWarehouseAreaTreeList(warehouse_id) {
  return defHttp.get({
    url: '/magic-api/mes/getWarehouseAreaTreeList?warehouse_id=' + warehouse_id,
  });
}
/**
 * 0-工厂、1-车间、2产线,3-工位
 */
export async function getMesFactoryListByType(type: number, parentId: string) {
  return defHttp.get({
    url: '/magic-api/mes/mesFactory?factory_type=' + type + '&parent_id=' + parentId,
  });
}

/**
 * 查询所有车间&产线
 */
export async function getMesCarLineTreeList() {
  return defHttp.get({
    url: '/magic-api/mes/getMesCarLineTreeList',
  });
}

/**
 * 班组
 */
export async function getMesGoupList() {
  return defHttp.get({
    url: '/magic-api/mes/getMesGoupList',
  });
}

/**
 * BOM
 */
export async function getBomListByProduct(material_id?: string, queryType: string) {
  return defHttp.get({
    url:
      '/magic-api/mes/getBomListByProduct?material_id=' + material_id + '&queryType=' + queryType,
  });
}
/**
 * 工艺
 * @param material_id
 */
export async function getProcessTechList(material_id?: string) {
  return defHttp.get({
    url: '/magic-api/mes/getProcessTechList?material_id=' + material_id,
  });
}
/**
 * 工艺路线
 * @param tech_id
 */
export async function getProcessTechStepList(tech_id?: string) {
  return defHttp.get({
    url: '/magic-api/mes/getProcessTechStepList?tech_id=' + tech_id,
  });
}

/**
 * 查询已有工单--工序步骤
 * @param tech_id
 */
export async function getWorkOrderStepList(work_id?: string) {
  return defHttp.get({
    url: '/mes/proorderworkstep/page?limit=1&size=100&workId=' + work_id,
  });
}

/**
 * 报工查询
 * @param work_id
 */
export async function getMesProWorkReportList(work_id: string) {
  return defHttp.get({
    url: '/magic-api/mes/getWorkOrderWorkReportList?workId=' + work_id,
  });
}
/**
 * 设备查询
 * @param work_id
 */
export async function getMesDevList() {
  return defHttp.get({
    url: '/magic-api/mes/getDevList',
  });
}

/**
 * 查询工单质检信息
 * @param workNo
 */
export async function getProduceOrderCheckId(workNo) {
  return defHttp.get({
    url: '/magic-api/mes/getProduceOrderCheckId?workNo=' + workNo,
  });
}

/**
 * 排期左侧销售订单查询
 * @param params
 * @param mode
 */
export async function getSalesOrderInfo(params, mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: '/magic-api/mes/getSaleOrderListSches',
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * 排期未完成产品查询
 * @param params
 * @param mode
 */
export async function getUnFilishScheProductList(params, mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: '/magic-api/mes/getUnFilishScheProductList',
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * 采购单列表
 */
export async function getBuyOrderList() {
  return defHttp.get({
    url: '/magic-api/mes/getBuyOrderList',
  });
}
/**
 * 生产工单列表
 */
export async function getWorkOrderList() {
  return defHttp.get({
    url: '/magic-api/mes/getWorkOrderList',
  });
}
/**
 * 销售单列表
 */
export async function getSaleOrderList() {
  return defHttp.get({
    url: '/magic-api/mes/getSaleOrderList',
  });
}

/**
 * 查询调拨申请列表
 */
export async function getMesWarehouseChgApplyList() {
  return defHttp.get({
    url: '/magic-api/mes/getMesWarehouseChgApplyList',
  });
}
/**
 * 查询调拨申请明细列表
 */
export async function getMesWarehouseChgApplyDetailList(apply_id) {
  return defHttp.get({
    url: '/magic-api/mes/getMesWarehouseChgApplyDetailList?apply_id=' + apply_id,
  });
}

/**
 * 工序列表查询
 */
export async function getProcessList(keyword) {
  return defHttp.get({
    url: '/magic-api/mes/getProcessList?keyword=' + keyword,
  });
}
/**
 * 工序类型
 */
export async function getProcessTypeList() {
  return defHttp.get({
    url: '/magic-api/mes/getProcessTypeList',
  });
}
