import {
  MesBaseSavetypeModel,
  MesBaseSavetypePageParams,
  MesBaseSavetypePageResult,
} from './model/BaseSavetypeModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/basesavetype/page',
  List = '/mes/basesavetype/list',
  Info = '/mes/basesavetype/info',
  MesBaseSavetype = '/mes/basesavetype',

  Export = '/mes/basesavetype/export',
}

/**
 * @description: 查询MesBaseSavetype分页列表
 */
export async function getMesBaseSavetypePage(
  params: MesBaseSavetypePageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesBaseSavetypePageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesBaseSavetype信息
 */
export async function getMesBaseSavetype(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseSavetypeModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesBaseSavetype
 */
export async function addMesBaseSavetype(
  mesBaseSavetype: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: Api.MesBaseSavetype,
      params: mesBaseSavetype,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesBaseSavetype
 */
export async function updateMesBaseSavetype(
  mesBaseSavetype: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.MesBaseSavetype,
      params: mesBaseSavetype,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesBaseSavetype（批量删除）
 */
export async function deleteMesBaseSavetype(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesBaseSavetype,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 导出MesBaseSavetype
 */
export async function exportMesBaseSavetype(params?: object, mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
