
import { RokePositionDictPageModel, RokePositionDictPageParams, RokePositionDictPageResult } from './model/ZwzdModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/zwzd/page',
  List = '/jcsj/zwzd/list',
  Info = '/jcsj/zwzd/info',
  RokePositionDict = '/jcsj/zwzd',
  
  
  
}

/**
 * @description: 查询RokePositionDict分页列表
 */
export async function getRokePositionDictPage(params: RokePositionDictPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokePositionDictPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取RokePositionDict信息
 */
export async function getRokePositionDict(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokePositionDictPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增RokePositionDict
 */
export async function addRokePositionDict(rokePositionDict: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.RokePositionDict,
      params: rokePositionDict,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新RokePositionDict
 */
export async function updateRokePositionDict(rokePositionDict: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.RokePositionDict,
      params: rokePositionDict,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除RokePositionDict（批量删除）
 */
export async function deleteRokePositionDict(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.RokePositionDict,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




