import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesBaseBom分页参数 模型
 */
export interface MesBaseBomPageParams extends BasicPageParams {
  bommc: string;

  cpid: string;

  sfyy: string;
}

/**
 * @description: MesBaseBom分页返回值模型
 */
export interface MesBaseBomPageModel {
  id: string;

  bommc: string;

  bomsl: string;

  bombb: string;

  cpmc: string;

  cpgg: string;

  cpxh: string;
}

/**
 * @description: MesBaseBom表类型
 */
export interface MesBaseBomModel {
  id: string;

  deleteMark: string;

  cpid: string;

  bommc: string;

  bomsl: string;

  sfyy: string;

  cpbh: string;

  cpmc: string;

  bombb: string;

  bz: string;

  cpgg: string;

  cpxh: string;

  p1: string;

  p2: string;

  p3: string;

  p4: string;

  p5: string;

  p6: string;

  p7: string;

  p8: string;

  p9: string;

  p10: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;

  mesBaseBomItemList?: MesBaseBomItemModel;
}

/**
 * @description: MesBaseBomItem表类型
 */
export interface MesBaseBomItemModel {
  id: string;

  deleteMark: string;

  bomid: string;

  wlbh: string;

  wlmc: string;

  wlsl: string;

  wlkcl: string;

  khbz: string;

  nkbz: string;

  sftl: string;

  p1: string;

  p2: string;

  p3: string;

  p4: string;

  p5: string;

  p6: string;

  p7: string;

  p8: string;

  p9: string;

  p10: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;

  bz: string;
}

/**
 * @description: MesBaseBom分页返回值结构
 */
export type MesBaseBomPageResult = BasicFetchResult<MesBaseBomPageModel>;
