
import { MesStorageLocationPageModel, MesStorageLocationPageParams, MesStorageLocationPageResult } from './model/HuoweiModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/huowei/page',
  List = '/jcsj/huowei/list',
  Info = '/jcsj/huowei/info',
  MesStorageLocation = '/jcsj/huowei',
  
  
  
}

/**
 * @description: 查询MesStorageLocation分页列表
 */
export async function getMesStorageLocationPage(params: MesStorageLocationPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesStorageLocationPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesStorageLocation信息
 */
export async function getMesStorageLocation(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesStorageLocationPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesStorageLocation
 */
export async function addMesStorageLocation(mesStorageLocation: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesStorageLocation,
      params: mesStorageLocation,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesStorageLocation
 */
export async function updateMesStorageLocation(mesStorageLocation: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesStorageLocation,
      params: mesStorageLocation,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesStorageLocation（批量删除）
 */
export async function deleteMesStorageLocation(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesStorageLocation,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




