
import { RokePartnerPageModel, RokePartnerPageParams, RokePartnerPageResult } from './model/GysglModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/gysgl/page',
  List = '/jcsj/gysgl/list',
  Info = '/jcsj/gysgl/info',
  RokePartner = '/jcsj/gysgl',
  
  
  
}

/**
 * @description: 查询RokePartner分页列表
 */
export async function getRokePartnerPage(params: RokePartnerPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokePartnerPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取RokePartner信息
 */
export async function getRokePartner(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokePartnerPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增RokePartner
 */
export async function addRokePartner(rokePartner: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.RokePartner,
      params: rokePartner,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新RokePartner
 */
export async function updateRokePartner(rokePartner: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.RokePartner,
      params: rokePartner,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除RokePartner（批量删除）
 */
export async function deleteRokePartner(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.RokePartner,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




