import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: RokeRouting分页参数 模型
 */
export interface RokeRoutingPageParams extends BasicPageParams {
  code: string;

  name: string;
}

/**
 * @description: RokeRouting分页返回值模型
 */
export interface RokeRoutingPageModel {
  id: string;

  code: string;

  name: string;

  note: string;
}

/**
 * @description: RokeRouting表类型
 */
export interface RokeRoutingModel {
  id: string;

  messageMainAttachmentId: string;

  name: string;

  code: string;

  internalCode: string;

  active: string;

  note: string;

  companyId: string;

  lotRuleId: string;

  autoDeduction: string;

  deductionAutoConfirm: string;

  deductionMoment: string;

  deductionBasis: string;

  deductionWorkCenter: string;

  documentId: string;

  productId: string;

  routingQualityMode: string;

  deleteMark: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;

  rokeRoutingProcessList?: RokeRoutingProcessModel;
}

/**
 * @description: RokeRoutingProcess表类型
 */
export interface RokeRoutingProcessModel {
  id: string;

  deleteMark: string;

  name: string;

  code: string;

  categoryId: string;

  processType: string;

  internalCode: string;

  active: string;

  withoutWoProduce: string;

  note: string;

  ratedWorkingHours: string;

  companyId: string;

  isPress: string;

  prepareWorkHours: string;

  collectionSchemeId: string;

  qualityMode: string;

  qcSchemeId: string;

  isQuality: string;

  salaryType: string;

  baseQty: string;

  salaryUnit: string;

  salary: string;

  salaryCode: string;

  qcSalaryBasis: string;

  qcSalaryType: string;

  qcBaseQty: string;

  qcSalaryUnit: string;

  qcSalary: string;

  qcSalaryCode: string;

  defaultReporter: string;

  collectionItem: string;

  inspectionCollectionItem: string;

  inspectionScheme: string;

  inspectionDepartment: string;

  inspectionStaff: string;

  defectProcessing: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;

  zyzdFile: string;

  zyzdtpFile: string;

  routingId: string;

  processId: string;

  px: string;

  processName: string;
}

/**
 * @description: RokeRouting分页返回值结构
 */
export type RokeRoutingPageResult = BasicFetchResult<RokeRoutingPageModel>;
