
import { RokeProcessCategoryPageModel, RokeProcessCategoryPageParams, RokeProcessCategoryPageResult } from './model/GxlbModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/gxlb/page',
  List = '/jcsj/gxlb/list',
  Info = '/jcsj/gxlb/info',
  RokeProcessCategory = '/jcsj/gxlb',
  
  
  
}

/**
 * @description: 查询RokeProcessCategory分页列表
 */
export async function getRokeProcessCategoryPage(params: RokeProcessCategoryPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokeProcessCategoryPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取RokeProcessCategory信息
 */
export async function getRokeProcessCategory(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokeProcessCategoryPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增RokeProcessCategory
 */
export async function addRokeProcessCategory(rokeProcessCategory: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.RokeProcessCategory,
      params: rokeProcessCategory,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新RokeProcessCategory
 */
export async function updateRokeProcessCategory(rokeProcessCategory: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.RokeProcessCategory,
      params: rokeProcessCategory,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除RokeProcessCategory（批量删除）
 */
export async function deleteRokeProcessCategory(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.RokeProcessCategory,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




