import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesBaseChejian分页参数 模型
 */
export interface MesBaseChejianPageParams extends BasicPageParams {
  cjbh: string;

  cjmc: string;
}

/**
 * @description: MesBaseChejian分页返回值模型
 */
export interface MesBaseChejianPageModel {
  id: string;

  cjbh: string;

  cjmc: string;

  bz: string;
}

/**
 * @description: MesBaseChejian表类型
 */
export interface MesBaseChejianModel {
  id: string;

  deleteMark: string;

  cjbh: string;

  cjmc: string;

  bz: string;

  p1: string;

  p2: string;

  p3: string;

  p4: string;

  p5: string;

  p6: string;

  p7: string;

  p8: string;

  p9: string;

  p10: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;

  mesBaseCjCxList?: MesBaseCjCxModel;
}

/**
 * @description: MesBaseCjCx表类型
 */
export interface MesBaseCjCxModel {
  id: string;

  deleteMark: string;

  cjid: string;

  cxid: string;

  cxbh: string;

  cxmc: string;

  bz: string;

  p1: string;

  p2: string;

  p3: string;

  p4: string;

  p5: string;

  p6: string;

  p7: string;

  p8: string;

  p9: string;

  p10: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;
}

/**
 * @description: MesBaseChejian分页返回值结构
 */
export type MesBaseChejianPageResult = BasicFetchResult<MesBaseChejianPageModel>;
