
import { RokeDepartmentPageModel, RokeDepartmentPageParams, RokeDepartmentPageResult } from './model/BkxxModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/bkxx/page',
  List = '/jcsj/bkxx/list',
  Info = '/jcsj/bkxx/info',
  RokeDepartment = '/jcsj/bkxx',
  
  
  
}

/**
 * @description: 查询RokeDepartment分页列表
 */
export async function getRokeDepartmentPage(params: RokeDepartmentPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokeDepartmentPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取RokeDepartment信息
 */
export async function getRokeDepartment(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokeDepartmentPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增RokeDepartment
 */
export async function addRokeDepartment(rokeDepartment: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.RokeDepartment,
      params: rokeDepartment,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新RokeDepartment
 */
export async function updateRokeDepartment(rokeDepartment: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.RokeDepartment,
      params: rokeDepartment,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除RokeDepartment（批量删除）
 */
export async function deleteRokeDepartment(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.RokeDepartment,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




