import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

export interface UnitPageListParams {
  name?: string; //单位名称
  isStandard?: number; //是否基准单位
}

export interface UnitAddParamsModel {
  name?: string; //单位名称
  isStandard?: number; //是否基准单位
  state?: number; //状态 0-关闭 1-开启
  symbol?: string; //单位符号
  unitTypeId?: string; //单位类型id
}

export interface UnitUpdateParamsModel {
  id: string; //详情id
  name?: string; //单位名称
  isStandard?: number; //是否基准单位
  state?: number; //状态 0-关闭 1-开启
  symbol?: string; //单位符号
  unitTypeId?: string; //单位类型id
}

export interface UnitListModel {
  id: string; //详情id
  name: string; //单位名称
  unitTypeName: string; //单位类型
  symbol: string; //单位符号
  isStandard: number; //是否基准单位
  createUserName: string; //创建人
  createDate: string; //创建时间
  state: number; //状态 0-关闭 1-开启
}

export type UnitPageListSearchModel = BasicPageParams & UnitPageListParams;
export type UnitPageListResultModel = BasicFetchResult<UnitListModel>;
