
import { MesWarehousePreparePageModel, MesWarehousePreparePageParams, MesWarehousePreparePageResult } from './model/ScblModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/ckgl/scbl/page',
  List = '/ckgl/scbl/list',
  Info = '/ckgl/scbl/info',
  MesWarehousePrepare = '/ckgl/scbl',
  
  
  
}

/**
 * @description: 查询MesWarehousePrepare分页列表
 */
export async function getMesWarehousePreparePage(params: MesWarehousePreparePageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehousePreparePageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesWarehousePrepare信息
 */
export async function getMesWarehousePrepare(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehousePreparePageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesWarehousePrepare
 */
export async function addMesWarehousePrepare(mesWarehousePrepare: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesWarehousePrepare,
      params: mesWarehousePrepare,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesWarehousePrepare
 */
export async function updateMesWarehousePrepare(mesWarehousePrepare: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesWarehousePrepare,
      params: mesWarehousePrepare,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesWarehousePrepare（批量删除）
 */
export async function deleteMesWarehousePrepare(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesWarehousePrepare,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




