
import { MesWarehouseBatchPageModel, MesWarehouseBatchPageParams, MesWarehouseBatchPageResult } from './model/PcglModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/ckgl/pcgl/page',
  List = '/ckgl/pcgl/list',
  Info = '/ckgl/pcgl/info',
  MesWarehouseBatch = '/ckgl/pcgl',
  
  
  
}

/**
 * @description: 查询MesWarehouseBatch分页列表
 */
export async function getMesWarehouseBatchPage(params: MesWarehouseBatchPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseBatchPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesWarehouseBatch信息
 */
export async function getMesWarehouseBatch(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseBatchPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesWarehouseBatch
 */
export async function addMesWarehouseBatch(mesWarehouseBatch: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesWarehouseBatch,
      params: mesWarehouseBatch,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesWarehouseBatch
 */
export async function updateMesWarehouseBatch(mesWarehouseBatch: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesWarehouseBatch,
      params: mesWarehouseBatch,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesWarehouseBatch（批量删除）
 */
export async function deleteMesWarehouseBatch(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesWarehouseBatch,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




