
import { MesWarehouseInPageModel, MesWarehouseInPageParams, MesWarehouseInPageResult } from './model/CgrkModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/ckgl/cgrk/page',
  List = '/ckgl/cgrk/list',
  Info = '/ckgl/cgrk/info',
  MesWarehouseIn = '/ckgl/cgrk',
  
  
  Export = '/ckgl/cgrk/export',
  
}

/**
 * @description: 查询MesWarehouseIn分页列表
 */
export async function getMesWarehouseInPage(params: MesWarehouseInPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseInPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesWarehouseIn信息
 */
export async function getMesWarehouseIn(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseInPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesWarehouseIn
 */
export async function addMesWarehouseIn(mesWarehouseIn: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesWarehouseIn,
      params: mesWarehouseIn,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesWarehouseIn
 */
export async function updateMesWarehouseIn(mesWarehouseIn: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesWarehouseIn,
      params: mesWarehouseIn,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesWarehouseIn（批量删除）
 */
export async function deleteMesWarehouseIn(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesWarehouseIn,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}



/**
 * @description: 导出MesWarehouseIn
 */
export async function exportMesWarehouseIn(
  params?: object, 
  mode: ErrorMessageMode = 'modal'
) {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
  

