
import { MesBaseGongzuoxiangPageModel, MesBaseGongzuoxiangPageParams, MesBaseGongzuoxiangPageResult } from './model/GzxModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/chaiche/gzx/page',
  List = '/chaiche/gzx/list',
  Info = '/chaiche/gzx/info',
  MesBaseGongzuoxiang = '/chaiche/gzx',
  
  
  
}

/**
 * @description: 查询MesBaseGongzuoxiang分页列表
 */
export async function getMesBaseGongzuoxiangPage(params: MesBaseGongzuoxiangPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseGongzuoxiangPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesBaseGongzuoxiang信息
 */
export async function getMesBaseGongzuoxiang(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseGongzuoxiangPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesBaseGongzuoxiang
 */
export async function addMesBaseGongzuoxiang(mesBaseGongzuoxiang: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesBaseGongzuoxiang,
      params: mesBaseGongzuoxiang,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesBaseGongzuoxiang
 */
export async function updateMesBaseGongzuoxiang(mesBaseGongzuoxiang: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesBaseGongzuoxiang,
      params: mesBaseGongzuoxiang,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesBaseGongzuoxiang（批量删除）
 */
export async function deleteMesBaseGongzuoxiang(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesBaseGongzuoxiang,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




