
import { MesBaseCheliangPageModel, MesBaseCheliangPageParams, MesBaseCheliangPageResult } from './model/CheliangxxModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/chaiche/cheliangxx/page',
  List = '/chaiche/cheliangxx/list',
  Info = '/chaiche/cheliangxx/info',
  MesBaseCheliang = '/chaiche/cheliangxx',
  
  
  
}

/**
 * @description: 查询MesBaseCheliang分页列表
 */
export async function getMesBaseCheliangPage(params: MesBaseCheliangPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseCheliangPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesBaseCheliang信息
 */
export async function getMesBaseCheliang(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseCheliangPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesBaseCheliang
 */
export async function addMesBaseCheliang(mesBaseCheliang: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesBaseCheliang,
      params: mesBaseCheliang,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesBaseCheliang
 */
export async function updateMesBaseCheliang(mesBaseCheliang: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesBaseCheliang,
      params: mesBaseCheliang,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesBaseCheliang（批量删除）
 */
export async function deleteMesBaseCheliang(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesBaseCheliang,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




