import {
	http
} from '@/common/request/index.js'; // 局部引入

const Api = {
	Page : '/dataconfig/modalmanage/page',
	List : '/dataconfig/modalmanage/list',
	Info : '/dataconfig/modalmanage/info', 
} 
/**
 * @description: 查询ModalManage分页列表
 */
export const getModalManagePage=(params) =>{
  return http.get(Api.Page, { params });
} 
/**
 * @description: 查询ModalManage不分页列表
 */
export const getModalManageList=(params) =>{
  return http.get(Api.List, { params });
}  
/**
 * @description: 获取ModalManage信息
 */
export const getModalManage=(id) =>{
  return http.get(Api.Info, { params: { id } });
}  
 
