
import {
  http
} from '@/common/request/index.js'; // 局部引入

const api = {
  Page : '/scgl/scjh/page',
  List : '/scgl/scjh/list',
  Info : '/scgl/scjh/info',
  MesProductionPlan : '/scgl/scjh'
}

/**
 * 根据参数  查询MesProductionPlan分页列表
 * @param {Object} params - 查询参数  
 */
export const getMesProductionPlanPage = (params) => {
  return http.get(api.Page, {
    params
  })
}

  
/**
 * 根据参数 查询MesProductionPlan列表
 * @param {Object} params - 查询参数  
 */
export const getMesProductionPlanList = (params) => {
  return http.get(api.List, {
    params
  })
}

/**
 * 获取MesProductionPlan信息
 * @param {Object} params - id  
 */
export const getMesProductionPlan = (id) => {
  return http.get(api.Info, {
    params: { id },
  })
}

/**
 * 新增MesProductionPlan
 * @param {Object} params - 表单数据  
 */
export const addMesProductionPlan = (formData) => {
  return http.post(api.MesProductionPlan, formData)
}

/**
 * 修改MesProductionPlan
 * @param {Object} params - 表单数据  
 */
export const updateMesProductionPlan = (formData) => {
  return http.put(api.MesProductionPlan, formData)
}

/**
 * 删除MesProductionPlan（批量删除）
 * @param {Object} params - 表单数据  
 */
export const deleteMesProductionPlan = (ids) => {
  return http.delete(api.MesProductionPlan, ids)
}
