
import { MesQualityInspectionPlanPageModel, MesQualityInspectionPlanPageParams, MesQualityInspectionPlanPageResult } from './model/ZhijianfanganModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/zlgl/zhijianfangan/page',
  List = '/zlgl/zhijianfangan/list',
  Info = '/zlgl/zhijianfangan/info',
  MesQualityInspectionPlan = '/zlgl/zhijianfangan',
  
  
  
}

/**
 * @description: 查询MesQualityInspectionPlan分页列表
 */
export async function getMesQualityInspectionPlanPage(params: MesQualityInspectionPlanPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQualityInspectionPlanPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesQualityInspectionPlan信息
 */
export async function getMesQualityInspectionPlan(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQualityInspectionPlanPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesQualityInspectionPlan
 */
export async function addMesQualityInspectionPlan(mesQualityInspectionPlan: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesQualityInspectionPlan,
      params: mesQualityInspectionPlan,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesQualityInspectionPlan
 */
export async function updateMesQualityInspectionPlan(mesQualityInspectionPlan: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesQualityInspectionPlan,
      params: mesQualityInspectionPlan,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesQualityInspectionPlan（批量删除）
 */
export async function deleteMesQualityInspectionPlan(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesQualityInspectionPlan,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




