import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';

enum Api {
  Common = '/caseErpCustomer/caseErpCustomer/common',
  Export = '/caseErpCustomer/caseErpCustomer/export-common',
  Get = '/caseErpCustomer/caseErpCustomer/get-from-common',
}

/**
 * @description: 领取客户
 */
export async function getFromCommon(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<number>(
    {
      url: Api.Get,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 移入公海
 */
export async function transferCommon(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.put<number>(
    {
      url: Api.Common,
      params: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 导出
 */
export async function exportInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'POST',
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 下载模板
 */
export async function downloadTemplate(mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
