import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'orderNo',
    label: '生产订单编号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'saleOrderId',
    label: '销售单号',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/mes/getSaleOrderList',
        method: 'GET',
        apiId: 'copy1690958013341d31983',
        apiParams: [
          {
            key: '1',
            title: 'Query Params',
            tableInfo: [
              {
                name: 'keyword',
                value: null,
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
              {
                name: 'showLabel',
                value: 'code',
                description: '回显字段',
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: 'code',
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: 'value',
              },
              {
                name: 'queryType',
                value: null,
                description: '查询类型',
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
            ],
          },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var condition="";\r\n\r\nreturn db.select("SELECT t.id AS `key` ,t.id AS `value`,t.sale_number AS label,t.* FROM case_erp_sale t where audit_state=3  "+condition)',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'productName',
    label: '产品名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'onlineDate',
    label: '上线日期',
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },

  {
    field: 'priority',
    label: '优先级',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '1689840965516009473' },
      labelField: 'name',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'planNum',
    label: '计划产量',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'state',
    label: '状态',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'staticData',
      staticOptions: [
        { key: 1, label: '待计划', value: '1' },
        { key: 2, label: '已计划', value: '2' },
        { key: 3, label: '已作废', value: '3' },
      ],
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'realNum',
    label: '已生产数量',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'remark',
    label: '备注',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'speModel',
    label: '规格型号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'unity',
    label: '单位',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'createUserId',
    label: '创建人',
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
    colProps: { span: 8 },
  },

  {
    field: 'createDate',
    label: '创建时间',
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'orderNo',
    title: '生产订单编号',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'saleOrderId',
    title: '销售单号',
    componentType: 'associate-select',

    sorter: true,
  },

  {
    dataIndex: 'productId',
    title: '产品编码',
    componentType: 'associate-select',

    sorter: true,
  },

  {
    dataIndex: 'productName',
    title: '产品名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'onlineDate',
    title: '上线日期',
    componentType: 'date',

    sorter: true,
  },

  {
    dataIndex: 'priority',
    title: '优先级',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'planNum',
    title: '计划产量',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'state',
    title: '状态',
    componentType: 'select',

    customRender: ({ record }) => {
      const staticOptions = [
        { key: 1, label: '待计划', value: '1' },
        { key: 2, label: '已计划', value: '2' },
        { key: 3, label: '已作废', value: '3' },
      ];
      return staticOptions.filter((x) => x.value === record.state)[0]?.label;
    },
    sorter: true,
  },

  {
    dataIndex: 'realNum',
    title: '已生产数量',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,
  },

  {
    dataIndex: 'speModel',
    title: '规格型号',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'unity',
    title: '单位',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,
  },
];

export const formProps: FormProps = {
  labelWidth: '100px',
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '2c3b9c2d41a143758b82f5ba96b27753',
      field: 'orderNo',
      label: '生产订单编号',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入生产订单编号',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'faf32cc78fd049fdbfff04368eea6644',
      field: 'saleOrderId',
      label: '销售单号',
      type: 'associate-select',
      component: 'AssociateSelect',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择销售单号',
        showLabel: true,
        showSearch: false,
        disabled: false,
        datasourceType: 'api',
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/getSaleOrderList',
          method: 'GET',
          apiId: 'copy1690958013341d31983',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'keyword',
                  value: null,
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'showLabel',
                  value: 'code',
                  description: '回显字段',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: 'code',
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'queryType',
                  value: null,
                  description: '查询类型',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\n\r\nreturn db.select("SELECT t.id AS `key` ,t.id AS `value`,t.sale_number AS label,t.* FROM case_erp_sale t where audit_state=3  "+condition)',
        },
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'ca032b75fa7043ed960bae15693e3ad9',
      field: 'productId',
      label: '产品编码',
      type: 'associate-select',
      component: 'AssociateSelect',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择产品编码',
        showLabel: true,
        showSearch: false,
        disabled: false,
        datasourceType: 'api',
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/getSaleOrderProductList',
          method: 'GET',
          apiId: 'copy1691460260596d60862',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'keyword',
                  value: null,
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'showLabel',
                  value: 'code',
                  description: '回显字段',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: 'code',
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'queryType',
                  value: null,
                  description: '查询类型',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'sale_id',
                  value: 'sale_order_id',
                  description: '销售订单ID',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'data',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(sale_id!=null&&sale_id!=""){ \r\n    condition+=" and sale_id=#{sale_id}";\r\n}\r\nreturn db.select("SELECT t.id AS `key` ,t.id AS `value`,t.code AS label,t.* FROM case_erp_sale_detail t where 1=1  "+condition)',
        },
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'e5d3faebce0841869be6dc20eb2e6856',
      field: 'productName',
      label: '产品名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '产品名称请输入',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'ce47dfffaf0e4969aedb89389c1ee723',
      field: 'onlineDate',
      label: '上线日期',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        span: '',
        defaultValue: '',
        width: '100%',
        placeholder: '请选择上线日期',
        format: 'YYYY-MM-DD',
        showLabel: true,
        allowClear: true,
        disabled: false,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'accf0492227c4151856413ed695a09c4',
      field: 'priority',
      label: '优先级',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [],
        defaultSelect: '',
        datasourceType: 'dic',
        params: { itemId: '1689840965516009473' },
        labelField: 'name',
        valueField: 'value',
        apiConfig: {},
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        itemId: '1689840965516009473',
        style: { width: '100%' },
      },
    },
    {
      key: '6ac65b5f200a416db4079917f4c03185',
      field: 'planNum',
      label: '计划产量',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入计划产量',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'adee33d727494ba8b785a521c83c3f84',
      field: 'state',
      label: '状态',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: '待计划', value: '1' },
          { key: 2, label: '已计划', value: '2' },
          { key: 3, label: '已作废', value: '3' },
        ],
        defaultSelect: '1',
        datasourceType: 'staticData',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {},
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '5d19c1184d14452d8bc4469226485dc3',
      field: 'realNum',
      label: '已生产数量',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '已生产数量请输入',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'c3c12196818d42d4bdd4f0e5a40aa32a',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入备注',
        maxlength: null,
        rows: 4,
        autoSize: false,
        showCount: false,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'a5cc2d5a853645d3be216b6a2e737ab7',
      field: 'speModel',
      label: '规格型号',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '规格型号请输入',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '78e9373a0d2e42afa9012068209c313c',
      field: 'unity',
      label: '单位',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入单位',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '717054b1f5b34363b3588894ad6bda7b',
      field: 'createUserId',
      label: '创建人',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        span: '',
        width: '100%',
        placeholder: '',
        infoType: 0,
        loadAgain: false,
        showLabel: true,
        disabled: true,
        style: { width: '100%' },
      },
    },
    {
      key: '437e2dd8dcd2484f98b6ff42ee640494',
      field: 'createDate',
      label: '创建时间',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        span: '',
        width: '100%',
        placeholder: '',
        infoType: 0,
        loadAgain: false,
        showLabel: true,
        disabled: true,
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
