import WritePng from '/@/assets/images/write.png';

export interface SelectContent {
  type: string;
  text: string;
  placeholder?: string;
  options?: string[];
}

interface DataContent {
  type: string;
  text: string;
  placeholder?: string;
  options?: string[];
}

export interface DataTypes {
  title: string;
  detail: string;
  img?: string;
  icon?: string;
  color?: string;
  content?: DataContent[];
}

const color = {
  orange: '#ff9500',
  green: '#2fbc52',
  blue: '#0057ff',
  red: '#ff3b30',
  purple: '#9952e1',
};

export const all = [
  {
    title: '长文写作',
    detail: '分步骤生成大纲和文档',
    img: WritePng,
    content: [
      {
        type: 'span',
        text: '我是一名',
      },
      {
        type: 'tag',
        text: '公众号博主',
      },
      {
        type: 'span',
        text: '，帮我写一篇关于',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[主题]',
      },
      {
        type: 'span',
        text: '的',
      },
      {
        type: 'select',
        text: '文章',
        options: ['文章', '论文', '研究报告'],
      },
      {
        type: 'span',
        text: '。',
      },
    ],
  },
];

export const work = [
  {
    title: '话术',
    detail: '满足不同场景表达需求',
    icon: 'huashu',
    color: color.orange,
    content: [
      {
        type: 'span',
        text: '我是一名',
      },
      {
        type: 'tag',
        text: '打工人',
      },
      {
        type: 'span',
        text: '，帮我写一段面向',
      },
      {
        type: 'tag',
        text: '陌生同事',
      },
      {
        type: 'span',
        text: '的话术内容，不要太长，用于',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[使用场景]',
      },
      {
        type: 'span',
        text: '。',
      },
    ],
  },
  {
    title: '研究报告',
    detail: '深度研究，精准分析',
    icon: 'yanjiubaogao',
    color: color.green,
    content: [
      {
        type: 'span',
        text: '我的职业是',
      },
      {
        type: 'tag',
        text: '研究员',
      },
      {
        type: 'span',
        text: '，帮我写一篇关于',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[主题]',
      },
      {
        type: 'span',
        text: '的研究报告。',
      },
    ],
  },
  {
    title: '总结汇报',
    detail: '凝练你的工作成效',
    icon: 'zongjiehuibao',
    color: color.blue,
    content: [
      {
        type: 'span',
        text: '我的职业是',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[输入职业]',
      },
      {
        type: 'span',
        text: '，帮我写一份关于',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[目的：项目进展总结、团队工作成果或其他]',
      },
      {
        type: 'span',
        text: '的总结汇报，需要包含',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[项目进展总结]',
      },
      {
        type: 'span',
        text: '、',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[工作内容与成果]',
      },
      {
        type: 'span',
        text: '和',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[成果]',
      },
      {
        type: 'span',
        text: '。',
      },
    ],
  },
  {
    title: '心得体会',
    detail: '助你提炼归纳所感所悟',
    icon: 'xindetihui',
    color: color.blue,
    content: [
      {
        type: 'span',
        text: '我的职业是',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[输入职业]',
      },
      {
        type: 'span',
        text: '，帮我写一份关于',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[主题]',
      },
      {
        type: 'span',
        text: '的心得体会。',
      },
    ],
  },
  {
    title: '思想汇报',
    detail: '进行反思梳理和深入总结',
    icon: 'sixianghuibao',
    color: color.blue,
    content: [
      {
        type: 'span',
        text: '我的职业是',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[输入职业]',
      },
      {
        type: 'span',
        text: '，帮我写一份关于',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[主题]',
      },
      {
        type: 'span',
        text: '的思想汇报。',
      },
    ],
  },
  {
    title: '方案策划',
    detail: '量身定制各种方案',
    icon: 'fangancehua',
    color: color.red,
    content: [
      {
        type: 'span',
        text: '我是一名',
      },
      {
        type: 'tag',
        text: '职业策划人',
      },
      {
        type: 'span',
        text: '，帮我写一个',
      },
      {
        type: 'tag',
        text: '线下读书会活动',
      },
      {
        type: 'span',
        text: '的方案，需要包含但不限于策划目标、详细计划、所需资源和预算、效果评估、风险应对等。',
      },
    ],
  },
  {
    title: '演讲稿',
    detail: '打造精彩的演讲内容',
    icon: 'yanjianggao',
    color: color.orange,
    content: [
      {
        type: 'span',
        text: '我的职业是',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[输入职业]',
      },
      {
        type: 'span',
        text: '，帮我写一篇演讲稿，主题是关于',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[主题]',
      },
      {
        type: 'span',
        text: '，字数为',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[输入数字]',
      },
      {
        type: 'span',
        text: '左右。',
      },
    ],
  },
  {
    title: '申请',
    detail: '轻松生成各类申请',
    icon: 'shenqing',
    color: color.blue,
    content: [
      {
        type: 'span',
        text: '帮我写一个交给',
      },
      {
        type: 'tag',
        text: '学校',
      },
      {
        type: 'span',
        text: '关于',
      },
      {
        type: 'tag',
        text: '助学金',
      },
      {
        type: 'span',
        text: '的申请，理由是',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[一句话简述原因]',
      },
      {
        type: 'span',
        text: '。',
      },
    ],
  },
  {
    title: '邮件',
    detail: '撰写清晰专业的邮件',
    icon: 'youjian',
    color: color.blue,
    content: [
      {
        type: 'span',
        text: '帮我写一封发给',
      },
      {
        type: 'tag',
        text: '客户',
      },
      {
        type: 'span',
        text: '的邮件，内容是',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[一句话简述内容要求]',
      },
      {
        type: 'span',
        text: '。',
      },
    ],
  },
  {
    title: '会议纪要',
    detail: '搞笑整理会议要点',
    icon: 'huiyijiyao',
    color: color.blue,
    content: [
      {
        type: 'span',
        text: '帮我写一个讨论',
      },
      {
        type: 'tag',
        text: '周会',
      },
      {
        type: 'span',
        text: '会议纪要，语言需要正式的，需要包含本周会议的主要讨论内容、核心结论以及后续计划，字数在',
      },
      {
        type: 'tag',
        text: '500',
      },
      {
        type: 'span',
        text: '字左右。',
      },
    ],
  },
  {
    title: '日报',
    detail: '每日工作的清晰总结',
    icon: 'ribao',
    color: color.blue,
    content: [
      {
        type: 'span',
        text: '我的职业是',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[输入职业]',
      },
      {
        type: 'span',
        text: '，帮我写一份今天的日报，包含',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[工作内容与成果]',
      },
      {
        type: 'span',
        text: '和',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[后续计划]',
      },
      {
        type: 'span',
        text: '。',
      },
    ],
  },
  {
    title: '周报',
    detail: '总结一周的工作成果',
    icon: 'zhoubao',
    color: color.blue,
    content: [
      {
        type: 'span',
        text: '我的职业是',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[输入职业]',
      },
      {
        type: 'span',
        text: '，帮我写一份本周的周报总结，包含',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[工作内容与成果]',
      },
      {
        type: 'span',
        text: '和',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[后续计划]',
      },
      {
        type: 'span',
        text: '。',
      },
    ],
  },
  {
    title: '月报',
    detail: '全面回顾每月的工作',
    icon: 'yuebao',
    color: color.blue,
    content: [
      {
        type: 'span',
        text: '我的职业是',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[输入职业]',
      },
      {
        type: 'span',
        text: '，帮我写一份本月的月报总结，包含',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[工作内容与成果]',
      },
      {
        type: 'span',
        text: '、',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[反思]',
      },
      {
        type: 'span',
        text: '和',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[后续计划]',
      },
      {
        type: 'span',
        text: '。',
      },
    ],
  },
  {
    title: '大纲',
    detail: '创建清晰的写作结构',
    icon: 'dagang',
    color: color.green,
    content: [
      {
        type: 'span',
        text: '帮我生成一个关于',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[主题]',
      },
      {
        type: 'span',
        text: '的大纲，用于',
      },
      {
        type: 'tag',
        text: 'PowerPoint制作',
      },
      {
        type: 'span',
        text: '。',
      },
    ],
  },
  {
    title: '头脑风暴',
    detail: '激发创意的无限可能',
    icon: 'tounaofengbao',
    color: color.blue,
    content: [
      {
        type: 'span',
        text: '我是一名',
      },
      {
        type: 'tag',
        text: '产品经理',
      },
      {
        type: 'span',
        text: '，帮我就',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[主题]',
      },
      {
        type: 'span',
        text: '进行头脑风暴，不少于',
      },
      {
        type: 'tag',
        text: '10',
      },
      {
        type: 'span',
        text: '个点子，每个创新想法都不能和其他重复，需要有明显的差异性。',
      },
    ],
  },
];

export const marketing = [
  {
    title: '宣传文案',
    detail: '撰写各平台的推广方案',
    icon: 'xuanchuanfangan',
    color: color.red,
    content: [
      {
        type: 'span',
        text: '帮我写5个面向',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[人群]',
      },
      {
        type: 'span',
        text: '宣传',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[产品]',
      },
      {
        type: 'span',
        text: '的品牌营销slogan，简洁吸睛，富有创意。',
      },
    ],
  },
  {
    title: '方案策划',
    detail: '量身定制各种方案',
    icon: 'fangancehua',
    color: color.red,
    content: [
      {
        type: 'span',
        text: '我是一名',
      },
      {
        type: 'tag',
        text: '职业策划人',
      },
      {
        type: 'span',
        text: '，帮我写一个',
      },
      {
        type: 'tag',
        text: '线下读书会活动',
      },
      {
        type: 'span',
        text: '的方案，需要包含但不限于策划目标、详细计划、所需资源和预算、效果评估、风险应对等。',
      },
    ],
  },
  {
    title: '市场调研报告',
    detail: '精准分析市场洞察',
    icon: 'shichangtiaoyanbaogao',
    color: color.red,
    content: [
      {
        type: 'span',
        text: '我是一名',
      },
      {
        type: 'tag',
        text: '营销专家',
      },
      {
        type: 'span',
        text: '，帮我写一个关于',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[主题]',
      },
      {
        type: 'span',
        text: '的市场调研报告，需要包含调研背景、调研目标、调研方法、市场分析、总结建议等，以总分总结构呈现。',
      },
    ],
  },
  {
    title: '广告创意方案',
    detail: '创作吸引眼球的广告词',
    icon: 'guanggaochuangyifangan',
    color: color.red,
    content: [
      {
        type: 'span',
        text: '帮我给',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[产品]',
      },
      {
        type: 'span',
        text: '写10个广告创意文案，文案风格为',
      },
      {
        type: 'tag',
        text: '年轻人喜欢的幽默的',
      },
      {
        type: 'span',
        text: '，要求每个广告创意方案的字数控制在',
      },
      {
        type: 'tag',
        text: '50',
      },
      {
        type: 'span',
        text: '左右，每个创意文案不重复，有明显的差异。',
      },
    ],
  },
  {
    title: '推广策略',
    detail: '制定高效的营销推广方案',
    icon: 'tuiguangcelve',
    color: color.red,
    content: [
      {
        type: 'span',
        text: '帮我给',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[产品]',
      },
      {
        type: 'span',
        text: '写一篇推广策略，需要包含目标受众分析、推广渠道、传播策略、制定预算、效果评估方案等。',
      },
    ],
  },
  {
    title: '大纲',
    detail: '创建清晰的写作结构',
    icon: 'dagang',
    color: color.green,
    content: [
      {
        type: 'span',
        text: '帮我生成一个关于',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[主题]',
      },
      {
        type: 'span',
        text: '的大纲，用于',
      },
      {
        type: 'tag',
        text: 'PowerPoint制作',
      },
      {
        type: 'span',
        text: '。',
      },
    ],
  },
];

export const education = [
  {
    title: '作文',
    detail: '专为学生打造满分作文',
    icon: 'zuowen',
    color: color.green,
    content: [
      {
        type: 'span',
        text: '写一篇作文，主题为',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[这里输入作文题目]',
      },
      {
        type: 'span',
        text: '，作文水平为',
      },
      {
        type: 'tag',
        text: '高中',
      },
      {
        type: 'span',
        text: '，文体是',
      },
      {
        type: 'tag',
        text: '议论文',
      },
      {
        type: 'span',
        text: '，作文字数为',
      },
      {
        type: 'tag',
        text: '800',
      },
      {
        type: 'span',
        text: '左右。',
      },
    ],
  },
  {
    title: '论文',
    detail: '撰写专业详实的论文',
    icon: 'lunwen',
    color: color.green,
    content: [
      {
        type: 'span',
        text: '我的研究领域是',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[输入研究领域]',
      },
      {
        type: 'span',
        text: '，帮我写一篇关于',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[主题]',
      },
      {
        type: 'span',
        text: '的论文。',
      },
    ],
  },
  {
    title: '教案',
    detail: '打造多样化的教学方案',
    icon: 'jiaoan',
    color: color.blue,
    content: [
      {
        type: 'span',
        text: '帮我写一份教案，授课对象是',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[年龄学段]',
      },
      {
        type: 'span',
        text: '，主题是',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[课程名称]',
      },
      {
        type: 'span',
        text: '。',
      },
    ],
  },
  {
    title: '大纲',
    detail: '创建清晰的写作结构',
    icon: 'dagang',
    color: color.green,
    content: [
      {
        type: 'span',
        text: '帮我生成一个关于',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[主题]',
      },
      {
        type: 'span',
        text: '的大纲，用于',
      },
      {
        type: 'tag',
        text: 'PowerPoint制作',
      },
      {
        type: 'span',
        text: '。',
      },
    ],
  },
];

export const article = [
  {
    title: '文章',
    detail: '撰写各主流平台文章',
    icon: 'lunwen',
    color: color.green,
    content: [
      {
        type: 'span',
        text: '我是一个',
      },
      {
        type: 'tag',
        text: '博主',
      },
      {
        type: 'span',
        text: '，帮我写一篇关于',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[主题]',
      },
      {
        type: 'span',
        text: '的',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[平台：如公众号、知乎、头条等]',
      },
      {
        type: 'span',
        text: '文章，需要符合该平台写作风格。',
      },
    ],
  },
  {
    title: '小红书',
    detail: '打造吸睛的小红书内容',
    icon: 'xiaohongshu',
    color: color.red,
    content: [
      {
        type: 'span',
        text: '帮我生成一篇关于',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[主题]',
      },
      {
        type: 'span',
        text: '的小红书文案。文案需要包含标题和正文。标题需根据主题改编为小红书风格，适当使用 emoji 来增强视觉吸引力和情感表达。',
      },
    ],
  },
  {
    title: '朋友圈',
    detail: '精心设计的朋友圈文案',
    icon: 'pengyouquan',
    color: color.green,
    content: [
      {
        type: 'span',
        text: '帮我生成一条关于',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[主题]',
      },
      {
        type: 'span',
        text: '的朋友圈。',
      },
    ],
  },
  {
    title: '微博',
    detail: '撰写吸引眼球的微博',
    icon: 'weibo',
    color: color.orange,
    content: [
      {
        type: 'span',
        text: '我想对',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[主题]',
      },
      {
        type: 'span',
        text: '发一条微博，帮我写一个微博文案。',
      },
    ],
  },
  {
    title: '故事',
    detail: '编织触动心灵的故事',
    icon: 'gushi',
    color: color.orange,
    content: [
      {
        type: 'span',
        text: '帮我写一个关于',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[主题]',
      },
      {
        type: 'span',
        text: '的故事。确保故事引人入胜，情节丰富，字数在',
      },
      {
        type: 'tag',
        text: '500',
      },
      {
        type: 'span',
        text: '字左右。',
      },
    ],
  },
  {
    title: '评语',
    detail: '精准撰写个性化评语',
    icon: 'pingyu',
    color: color.orange,
    content: [
      {
        type: 'span',
        text: '帮我写一个发布在',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[平台]',
      },
      {
        type: 'span',
        text: '上对',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[输入评语类型：如电影评价]',
      },
      {
        type: 'span',
        text: '的',
      },
      {
        type: 'select',
        text: '好评',
        options: ['好评', '中评', '差评'],
      },
      {
        type: 'span',
        text: '，字数不少于',
      },
      {
        type: 'tag',
        text: '100',
      },
      {
        type: 'span',
        text: '字。',
      },
    ],
  },
];

export const literature = [
  {
    title: '诗歌',
    detail: '创作动人心弦的诗篇',
    icon: 'shige',
    color: color.orange,
    content: [
      {
        type: 'span',
        text: '帮我写一首关于',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[主题]',
      },
      {
        type: 'span',
        text: '的诗歌，格式是',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[输入古诗词或者现代诗的格式]',
      },
      {
        type: 'span',
        text: '。',
      },
    ],
  },
  {
    title: '故事',
    detail: '编织触动心灵的故事',
    icon: 'gushi',
    color: color.orange,
    content: [
      {
        type: 'span',
        text: '帮我写一个关于',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[主题]',
      },
      {
        type: 'span',
        text: '的故事。确保故事引人入胜，情节丰富，字数在',
      },
      {
        type: 'tag',
        text: '500',
      },
      {
        type: 'span',
        text: '字左右。',
      },
    ],
  },
  {
    title: '小说',
    detail: '创作引人入胜的小说',
    icon: 'xiaoshuo',
    color: color.orange,
    content: [
      {
        type: 'span',
        text: '帮我写一个小说，类型为',
      },
      {
        type: 'tag',
        text: '爱情',
      },
      {
        type: 'span',
        text: '，以',
      },
      {
        type: 'tag',
        text: '一个刚穿越到唐朝的医学生女生',
      },
      {
        type: 'span',
        text: '为主角，字数在',
      },
      {
        type: 'tag',
        text: '1000',
      },
      {
        type: 'span',
        text: '左右。',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[其他补充要求]',
      },
      {
        type: 'span',
        text: '。',
      },
    ],
  },
  {
    title: '演讲稿',
    detail: '打造精彩的演讲内容',
    icon: 'yanjianggao',
    color: color.orange,
    content: [
      {
        type: 'span',
        text: '我是一名',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[输入职业]',
      },
      {
        type: 'span',
        text: '，帮我写一篇演讲稿，主题是关于',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[主题]',
      },
      {
        type: 'span',
        text: '字数在',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[输入数字]',
      },
      {
        type: 'span',
        text: '左右。',
      },
    ],
  },
];

export const reply = [
  {
    title: '回复「评论」',
    detail: '轻松应对评论互动',
    icon: 'huifupinglun',
    color: color.purple,
    content: [
      {
        type: 'span',
        text: '帮我以',
      },
      {
        type: 'tag',
        text: '店主',
      },
      {
        type: 'span',
        text: '的身份回复回复下面提供的“评论”内容，需要对评论中提到的问题作出正向回复，回复态度亲和，用语礼貌：',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[这里输入评论内容]',
      },
    ],
  },
  {
    title: '回复「消息」',
    detail: '助你快速回复消息',
    icon: 'huifuxiaoxi',
    color: color.purple,
    content: [
      {
        type: 'span',
        text: '帮我以',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[输入职业]',
      },
      {
        type: 'span',
        text: '身份回复下面提供的“消息”内容：',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[这里输入消息内容]',
      },
    ],
  },
  {
    title: '回复「邮件」',
    detail: '撰写得体的邮件回复',
    icon: 'huifuyoujian',
    color: color.purple,
    content: [
      {
        type: 'span',
        text: '帮我以',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[输入职业]',
      },
      {
        type: 'span',
        text: '身份回复下面提供的“邮件”内容，我要在邮件中告知对方',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[一句话简述内容要求]',
      },
      {
        type: 'span',
        text: '：',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[这里输入邮件内容]',
      },
    ],
  },
  {
    title: '润色',
    detail: '让文字表达更出彩',
    icon: 'runse',
    color: color.purple,
    content: [
      {
        type: 'span',
        text: '帮我对以下内容进行润色，润色要求',
      },
      {
        type: 'tag',
        text: '语言风格幽默',
      },
      {
        type: 'span',
        text: '，润色字数限制为',
      },
      {
        type: 'tag',
        text: '不限',
      },
      {
        type: 'span',
        text: '：',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[这里输入要优化的内容]',
      },
    ],
  },
  {
    title: '校对',
    detail: '保证内容无误',
    icon: 'xiaodui',
    color: color.purple,
    content: [
      {
        type: 'span',
        text: '帮我对以下内容进行校对并修改',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[这里输入要优化的内容]',
      },
    ],
  },
  {
    title: '调整语气',
    detail: '调整语气适配不同场合',
    icon: 'tiaozhengyuqi',
    color: color.purple,
    content: [
      {
        type: 'span',
        text: '帮我将以下内容的语气调整为',
      },
      {
        type: 'select',
        text: '正式的',
        options: ['正式的', '随意的', '专业的', '热情的', '有信息量的', '有趣的'],
      },
      {
        type: 'span',
        text: '：',
      },
      {
        type: 'placeholder',
        text: '',
        placeholder: '[这里输入要优化的内容]',
      },
    ],
  },
];
