import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'danXingWenBen',
    label: '单行文本',
    component: 'Input',
    colProps: { span: 8 },
  },

  {
    field: 'duoXingWenBen',
    label: '多行文本',
    component: 'Input',
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'danXingWenBen',
    title: '单行文本',
    componentType: 'input',
  },

  {
    dataIndex: 'duoXingWenBen',
    title: '多行文本',
    componentType: 'textarea',
  },
];

export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '235a0c8c372c4cc482b8242f4da83d51',
      field: 'danXingWenBen',
      label: '单行文本',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        defaultValue: '',
        placeholder: '请输入单行文本',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        style: { width: '100%' },
      },
    },
    {
      key: '8fdc939de18841578122935a55c848bb',
      field: 'duoXingWenBen',
      label: '多行文本',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        defaultValue: '',
        placeholder: '请输入多行文本',
        maxlength: null,
        rows: 4,
        autoSize: false,
        showCount: false,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        rules: [],
        style: { width: '100%' },
      },
    },
    {
      key: '6561dff201714bb6b5f12814bde0c6bf',
      field: 'bianJiQi',
      label: '编辑器',
      type: 'richtext-editor',
      component: 'RichTextEditor',
      colProps: { span: 24 },
      componentProps: {
        value: '',
        width: '100%',
        disabled: false,
        showLabel: true,
        required: false,
        rules: [],
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
