import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesDevType分页参数 模型
 */
export interface MesDevTypePageParams extends BasicPageParams {
  typeCode: string;

  typeName: string;
}

/**
 * @description: MesDevType分页返回值模型
 */
export interface MesDevTypePageModel {
  id: string;

  typeCode: string;

  typeName: string;

  state: string;

  remark: string;

  createUserId: string;

  createDate: string;
}

/**
 * @description: MesDevType表类型
 */
export interface MesDevTypeModel {
  id: number;

  typeCode: string;

  typeName: string;

  sort: number;

  state: number;

  remark: string;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesDevType分页返回值结构
 */
export type MesDevTypePageResult = BasicFetchResult<MesDevTypePageModel>;