
import { RokeEmployeePageModel, RokeEmployeePageParams, RokeEmployeePageResult } from './model/RyxxModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/ryxx/page',
  List = '/jcsj/ryxx/list',
  Info = '/jcsj/ryxx/info',
  RokeEmployee = '/jcsj/ryxx',
  
  
  
}

/**
 * @description: 查询RokeEmployee分页列表
 */
export async function getRokeEmployeePage(params: RokeEmployeePageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokeEmployeePageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取RokeEmployee信息
 */
export async function getRokeEmployee(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokeEmployeePageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增RokeEmployee
 */
export async function addRokeEmployee(rokeEmployee: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.RokeEmployee,
      params: rokeEmployee,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新RokeEmployee
 */
export async function updateRokeEmployee(rokeEmployee: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.RokeEmployee,
      params: rokeEmployee,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除RokeEmployee（批量删除）
 */
export async function deleteRokeEmployee(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.RokeEmployee,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




