
import { MesBaseGzzxPageModel, MesBaseGzzxPageParams, MesBaseGzzxPageResult } from './model/GzzxModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/gzzx/page',
  List = '/jcsj/gzzx/list',
  Info = '/jcsj/gzzx/info',
  MesBaseGzzx = '/jcsj/gzzx',
  
  
  
}

/**
 * @description: 查询MesBaseGzzx分页列表
 */
export async function getMesBaseGzzxPage(params: MesBaseGzzxPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseGzzxPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesBaseGzzx信息
 */
export async function getMesBaseGzzx(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseGzzxPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesBaseGzzx
 */
export async function addMesBaseGzzx(mesBaseGzzx: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesBaseGzzx,
      params: mesBaseGzzx,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesBaseGzzx
 */
export async function updateMesBaseGzzx(mesBaseGzzx: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesBaseGzzx,
      params: mesBaseGzzx,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesBaseGzzx（批量删除）
 */
export async function deleteMesBaseGzzx(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesBaseGzzx,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




