
import { RokeProcessPageModel, RokeProcessPageParams, RokeProcessPageResult } from './model/GxglModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/gxgl/page',
  List = '/jcsj/gxgl/list',
  Info = '/jcsj/gxgl/info',
  RokeProcess = '/jcsj/gxgl',
  
  
  
}

/**
 * @description: 查询RokeProcess分页列表
 */
export async function getRokeProcessPage(params: RokeProcessPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokeProcessPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取RokeProcess信息
 */
export async function getRokeProcess(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokeProcessPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增RokeProcess
 */
export async function addRokeProcess(rokeProcess: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.RokeProcess,
      params: rokeProcess,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新RokeProcess
 */
export async function updateRokeProcess(rokeProcess: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.RokeProcess,
      params: rokeProcess,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除RokeProcess（批量删除）
 */
export async function deleteRokeProcess(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.RokeProcess,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




