
import { MesBaseChanxianPageModel, MesBaseChanxianPageParams, MesBaseChanxianPageResult } from './model/CxglModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/cxgl/page',
  List = '/jcsj/cxgl/list',
  Info = '/jcsj/cxgl/info',
  MesBaseChanxian = '/jcsj/cxgl',
  
  
  
}

/**
 * @description: 查询MesBaseChanxian分页列表
 */
export async function getMesBaseChanxianPage(params: MesBaseChanxianPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseChanxianPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesBaseChanxian信息
 */
export async function getMesBaseChanxian(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseChanxianPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesBaseChanxian
 */
export async function addMesBaseChanxian(mesBaseChanxian: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesBaseChanxian,
      params: mesBaseChanxian,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesBaseChanxian
 */
export async function updateMesBaseChanxian(mesBaseChanxian: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesBaseChanxian,
      params: mesBaseChanxian,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesBaseChanxian（批量删除）
 */
export async function deleteMesBaseChanxian(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesBaseChanxian,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




