import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesWarehouseCheck分页参数 模型
 */
export interface MesWarehouseCheckPageParams extends BasicPageParams {
  dataCode: string;

  dataDate: string;

  dataName: string;

  dataStorage: string;

  dataUser: string;

  createUserId: string;

  createDateStart: string;
  createDateEnd: string;
}

/**
 * @description: MesWarehouseCheck分页返回值模型
 */
export interface MesWarehouseCheckPageModel {
  id: string;

  dataCode: string;

  dataDate: string;

  dataName: string;

  dataStorage: string;

  dataUser: string;

  remark: string;

  createUserId: string;

  createDate: string;
}

/**
 * @description: MesWarehouseCheck表类型
 */
export interface MesWarehouseCheckModel {
  id: number;

  isSysNum: string;

  dataCode: string;

  dataName: string;

  dataDate: string;

  dataStorage: string;

  dataUser: string;

  dataFile: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;

  mesWarehouseCheckDetailList?: MesWarehouseCheckDetailModel;
}

/**
 * @description: MesWarehouseCheckDetail表类型
 */
export interface MesWarehouseCheckDetailModel {
  id: number;

  checkId: number;

  productNo: string;

  productName: string;

  productId: string;

  speModel: string;

  deType: string;

  unity: string;

  sysNum: string;

  realNum: string;

  lostNum: string;

  checkResult: string;

  remark: string;
  areaId: string;
  locationId: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesWarehouseCheck分页返回值结构
 */
export type MesWarehouseCheckPageResult = BasicFetchResult<MesWarehouseCheckPageModel>;
