import { MesQbSemifinReportModel, MesQbSemifinReportPageParams, MesQbSemifinReportPageResult } from './model/MesSemiFinishReportModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/messemifinishreport/page',
  List = '/mes/messemifinishreport/list',
  Info = '/mes/messemifinishreport/info',
  MesQbSemifinReport = '/mes/messemifinishreport',
  
  
}

/**
 * @description: 查询MesQbSemifinReport分页列表
 */
export async function getMesQbSemifinReportPage(params: MesQbSemifinReportPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQbSemifinReportPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesQbSemifinReport信息
 */
export async function getMesQbSemifinReport(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQbSemifinReportModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesQbSemifinReport
 */
export async function addMesQbSemifinReport(mesQbSemifinReport: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesQbSemifinReport,
      params: mesQbSemifinReport,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesQbSemifinReport
 */
export async function updateMesQbSemifinReport(mesQbSemifinReport: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesQbSemifinReport,
      params: mesQbSemifinReport,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesQbSemifinReport（批量删除）
 */
export async function deleteMesQbSemifinReport(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesQbSemifinReport,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}