import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

export interface SalePageListParams {
  theme?: string; //订单主题
}

export interface SalePageListModel {
  id: string; //详情id
  saleNumber: string; //销售单号
  theme: string; //销售订单主题
  customerName: string; //客户名称
  saleDate: string; //销售日期
  saleDetail: string; //产品概要
  amountSum: number; //总金额
  discount: number; //优惠后金额
  alreadyAmount: number; //已收金额
  alreadyTicket: number; //已到票金额
  outStoreState: number; //出库
  ticketState: number; //开票
  payState: number; //收款
}

export interface SaleAddParamsModel {
  saleNumber: string; //销售单号
  isSysNumBoolean: boolean; //是否使用系统编号
  theme: string; //订单主题
  saleDate?: string; //销售日期
  customerId?: string; //客户名称
  clientPerson?: string; //联系人
  clientWay?: string; //联系方式
  manager?: string; //客户经理
  depName?: string; //所属部门
  phone?: string; //联系电话
  relatedProject?: string; //关联项目
  payType?: string; //结算方式
  clientNumber?: string; //客户订单号
  payAddress?: string; //交货地址
  remark?: string; //备注
  filePath?: string; //图片地址
  addCaseErpSaleDetailDtoList?: SaleDetailParamsModel[];
}
export interface SaleDetailParamsModel {
  code: string; //产品编码
  name: string; //产品名称
  model: string; //规格型号
  unitName: string; //单位
  price?: number; //单价
  count?: number; //销售数量
  discount?: number; //折扣
  taxRate?: string; //税率
  taxBreak?: string; //税费
  afterTaxAmount?: string; //税后金额
  deliveryDate?: string; //交付日期
  remark?: string; //备注
}

export interface SaleUpdateParamsModel {
  id: string; //详情id
  saleNumber: string; //销售单号
  isSysNumBoolean: boolean; //是否使用系统编号
  theme: string; //订单主题
  saleDate?: string; //销售日期
  customerId?: string; //客户名称
  clientPerson?: string; //联系人
  clientWay?: string; //联系方式
  manager?: string; //客户经理
  depName?: string; //所属部门
  phone?: string; //联系电话
  relatedProject?: string; //关联项目
  payType?: string; //结算方式
  clientNumber?: string; //客户订单号
  payAddress?: string; //交货地址
  remark?: string; //备注
  filePath?: string; //图片地址
  addCaseErpSaleDetailDtoList?: SaleDetailParamsModel[];
}

export interface SaleInfoModel {
  id: string; //详情id
  saleNumber: string; //销售单号
  isSysNumBoolean: boolean; //是否使用系统编号
  theme: string; //订单主题
  saleDate?: string; //销售日期
  customerId?: string; //客户名称
  clientPerson?: string; //联系人
  clientWay?: string; //联系方式
  manager?: string; //客户经理
  depName?: string; //所属部门
  phone?: string; //联系电话
  relatedProject?: string; //关联项目
  payType?: string; //结算方式
  clientNumber?: string; //客户订单号
  payAddress?: string; //交货地址
  remark?: string; //备注
  filePath?: string; //图片地址
  countSum: number; //总量
  amountSum: number; //总金额
  discount: number; //优惠金额
  caseErpSaleDetailList?: SaleDetailParamsModel[];
}

export interface SaleCheckInfoModel {
  id: string; //详情id
  theme: string; //销售订单主题
  createUserName: string; //创建人
  createDate: string; //创建时间
  modifyUserName: string; //最后修改人
  modifyDate: string; //修改时间
  saleNumber: string; //销售单号
  saleDate: string; //销售日期
  customerName: string; //客户名称
  clientPerson: string; //联系人
  clientWay: string; //联系方式
  manager: string; //客户经理
  depName: string; //所属部门
  phone: string; //联系电话
  relatedProjectName: string; //关联项目
  payTypeName: string; //结算方式
  clientNumber: string; //客户订单号
  payAddress: string; //交货地址
  remark: string; //备注
  countSum: number; //总量
  amountSum: number; //总金额
  discount: number; //优惠金额
  filePath: string; //附件
  outStoreState: number; //出库
  ticketState: number; //开票
  payState: number; //收款
  caseErpSaleDetailList: SaleDetailParamsModel[];
  outstoreList: SaleOutstoreInfoModel[];
  invoiceList: SaleInvoiceInfoModel[];
  collectionList: SaleCollectionInfoModel[];
  productList: SaleProductInfoModel[];
  logList: SaleLogInfoModel[];
}

export interface SaleOutstoreInfoModel {
  code: string; //出库单号
  theme: string; //出库订单主题
  date: string; //出库日期
  name: string; //客户名称
  count: number; //出库总量
  person: string; //出库人员
  store: string; //出库仓库
}

export interface SaleInvoiceInfoModel {
  code: string; //开票编号
  theme: string; //开票主题
  date: string; //开票日期
  invoiceName: string; //发票类型
  ticketNum: string; //发票号码
  ticketAmout: number; //发票金额
  ticketName: string; //收款方
}

export interface SaleCollectionInfoModel {
  code: string; //收款编号
  theme: string; //收入主题
  date: string; //收入日期
  amount: string; //收款总额
  payer: string; //付款方
  account: string; //银行账号
}

export interface SaleProductInfoModel {
  code: string; //生产编号
  theme: string; //生产主题
  type: string; //生产类型
  date: string; //单据日期
  person: string; //负责人
  dep: string; //生产部门
  state: number; //状态
}

export interface SaleLogInfoModel {
  operateUserAccount: string; //操作人
  createDate: string; //操作时间
  executeResultJson: string; //操作类型
}

export type SalePageListSearchModel = BasicPageParams & SalePageListParams;
export type SalePageListResultModel = BasicFetchResult<SalePageListModel>;
