import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';
enum Api {
  Source = '/caseErpCustomer/caseErpCustomer/customer-source',
  Type = '/caseErpCustomer/caseErpCustomer/customer-type',
  Gather = '/caseErpCustomer/caseErpCustomer/customer-gather',
  Customer = '/caseErpCustomer/caseErpCustomer/customer-statistics',
}

/**
 * @description: 客户来源统计
 */
export async function getSourceInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Source,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询客户类型分布
 */
export async function getTypeInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Type,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询客户回款
 */
export async function getGatherInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Gather,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 统计今日客户
 */
export async function getCustomerInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Customer,
    },
    {
      errorMessageMode: mode,
    },
  );
}
