import { FormProps } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { uploadApi } from '/@/api/sys/upload';

export const columns: BasicColumn[] = [
  {
    dataIndex: 'applyNumber',
    title: '请购单号',
    componentType: 'input',
    resizable: true,
  },
  {
    dataIndex: 'theme',
    title: '请购主题',
    componentType: 'input',
    resizable: true,
  },

  {
    dataIndex: 'applyDate',
    title: '请购日期',
    componentType: 'date',
    resizable: true,
    width: 100,
  },

  {
    dataIndex: 'purchaseStatus',
    title: '采购状态',
    customRender: ({ record }) => {
      return record.purchaseStatus ? '已采购' : '未采购';
    },
    width: 100,
  },

  {
    dataIndex: 'applyUserName',
    title: '采购人员',
    componentType: 'user',
    width: 100,
  },

  {
    dataIndex: 'applyDetail',
    title: '物品概要',
  },

  {
    dataIndex: 'applyDepName',
    title: '请购部门',
    componentType: 'organization',
  },
  {
    dataIndex: 'applyUserName',
    title: '请购人员',
    componentType: 'user',
    width: 100,
  },
  {
    dataIndex: 'relatedProjectName',
    title: '关联项目',
    componentType: 'select',
  },
];

export const formProps: FormProps = {
  labelCol: { span: 2, offset: 0 },
  labelAlign: 'right',
  size: 'default',
  layout: 'vertical',
  schemas: [
    {
      key: 'ca555e9dad404e04a3939f09a3c27044',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 12,
          list: [
            {
              key: '4980ff6f41bc437e9530ce0ec91de963',
              field: '',
              label: '',
              type: 'grid',
              colProps: { span: 24 },
              component: 'Grid',
              children: [
                {
                  span: 18,
                  list: [
                    {
                      key: '4d0964ebb5a246b9969871bcdaa2cb17',
                      field: 'applyNumber',
                      label: '申请单号',
                      type: 'input',
                      component: 'Input',
                      colProps: { span: 24 },
                      defaultValue: '',
                      componentProps: {
                        width: '100%',
                        span: 6,
                        defaultValue: '',
                        placeholder: '请输入申请单号',
                        maxlength: null,
                        prefix: '',
                        suffix: '',
                        addonBefore: '',
                        addonAfter: '',
                        disabled: false,
                        allowClear: false,
                        showLabel: true,
                        required: true,
                        rules: [],
                        events: {},
                        style: { width: '100%' },
                      },
                    },
                  ],
                },
                {
                  span: 6,
                  list: [
                    {
                      key: 'b3ba87573cf0466d951bc63fd4df1c78',
                      field: 'isSysNum',
                      label: '',
                      type: 'checkbox',
                      component: 'ApiCheckboxGroup',
                      colProps: { span: 24 },
                      componentProps: {
                        span: 7,
                        showLabel: true,
                        disabled: false,
                        staticOptions: [{ key: 1, label: '用系统编号', value: '1' }],
                        datasourceType: 'staticData',
                        defaultSelect: '1',
                        labelField: 'label',
                        valueField: 'value',
                        apiConfig: {},
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        style: {},
                      },
                    },
                  ],
                },
              ],
              componentProps: { gutter: 16, justify: 'start', align: 'top', span: 7 },
            },
          ],
        },
        { span: 12, list: [] },
      ],
      componentProps: { gutter: 16, justify: 'start', align: 'top' },
    },
    {
      key: '891431243da0459d8c7def90d854002c',
      field: 'theme',
      label: '申请主题',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入申请主题',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'c0cd005cf792430c87458b3761b793a2',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 12,
          list: [
            {
              key: '25acf86d4ffe453d9ea5f113b276f669',
              field: 'applyDate',
              label: '申请日期',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 4,
                defaultValue: '',
                width: '100%',
                placeholder: '请选择申请日期',
                format: 'YYYY-MM-DD',
                showLabel: true,
                allowClear: true,
                disabled: false,
                required: true,
                rules: [],
                events: {},
                style: { width: '100%' },
              },
            },
            {
              key: 'c9eb0e20e21c47b984a2c5d080cf98c4',
              field: 'applyUserIds',
              label: '申请人员',
              type: 'user',
              component: 'User',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 4,
                width: '100%',
                defaultValue: '',
                placeholder: '请选择申请人员',
                userType: 0,
                prefix: '',
                suffix: 'ant-design:setting-outlined',
                showLabel: true,
                disabled: false,
                required: false,
                multiple: false,
                events: {},
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 12,
          list: [
            {
              key: '392215a25f9f4c81bc23cf9c8ba87e74',
              field: 'applyDepId',
              label: '申请部门',
              type: 'organization',
              component: 'Dept',
              colProps: { span: 24 },
              componentProps: {
                span: 4,
                width: '100%',
                orgzType: 0,
                placeholder: '请选择申请部门',
                showLabel: true,
                disabled: false,
                required: false,
                events: {},
                style: { width: '100%' },
              },
            },
            {
              key: '97394dc0655a42a381813e4975a29e63',
              field: 'relatedProject',
              label: '关联项目',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 4,
                placeholder: '请选择关联项目',
                showLabel: true,
                showSearch: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '',
                datasourceType: 'dic',
                params: { itemId: '1680768933996957698' },
                labelField: 'name',
                valueField: 'id',
                apiConfig: {},
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                itemId: '1680768933996957698',
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: { gutter: 16, justify: 'start', align: 'top' },
    },
    {
      key: 'c7a6fbe82805417cb0b41bc1a6aa9999',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入备注',
        maxlength: null,
        rows: 4,
        autoSize: false,
        showCount: false,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'fb8a6d7b353a4b2c974a3f1bcf3a3985',
      label: '物品明细',
      field: 'caseErpApplyDetailList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'caseErpApplyDetailList',
        columns: [
          {
            key: '933cab4edd2047ca87b9c17683ae2702',
            title: '物料编码',
            dataIndex: 'code',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入物料编码',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: false,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '20a6d2b20a1448189aa844a0043c140f',
            title: '物料名称',
            dataIndex: 'name',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入物料名称',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '7d422b2139284ce29b4124a6c29104af',
            title: '规格型号',
            dataIndex: 'model',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入规格型号',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: 'a482fdb6b3044cf18264fcf3a7baf49b',
            title: '单位',
            dataIndex: 'unitName',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入单位',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '55a712069b7d46259bffb752ee0064af',
            title: '预计单价',
            dataIndex: 'price',
            componentType: 'InputNumber',
            defaultValue: 0,
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: 0,
              min: 0,
              max: 100,
              step: 1,
              maxlength: null,
              disabled: false,
              showLabel: true,
              controls: true,
              required: false,
              subTotal: false,
              rules: [],
              events: {},
            },
          },
          {
            key: 'be2cec3741474bab97dd5fd7e1c0d2fc',
            title: '申请数量',
            dataIndex: 'count',
            componentType: 'InputNumber',
            defaultValue: 0,
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: 0,
              min: 0,
              max: 100,
              step: 1,
              maxlength: null,
              disabled: false,
              showLabel: true,
              controls: true,
              required: false,
              subTotal: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '93efc02d14db4cc5aa3882db8a6b69b9',
            title: '预计金额',
            dataIndex: 'amount',
            componentType: 'InputNumber',
            defaultValue: 0,
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: 0,
              min: 0,
              max: 100,
              step: 1,
              maxlength: null,
              disabled: true,
              showLabel: true,
              controls: true,
              required: false,
              subTotal: false,
              rules: [],
              events: {},
            },
          },
          {
            key: 'b328bb18405a4c41bb36d12bfe65da16',
            title: '交付日期',
            dataIndex: 'payDate',
            componentType: 'DatePicker',
            defaultValue: '',
            componentProps: {
              span: '',
              defaultValue: '',
              width: '100%',
              placeholder: '请选择交付日期',
              format: 'YYYY-MM-DD',
              showLabel: true,
              allowClear: true,
              disabled: false,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '97dbac431ae64cb5acd9c11fcb1350b0',
            title: '用途',
            dataIndex: 'purpose',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入用途',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        span: '24',
        preloadType: 'api',
        apiConfig: {},
        itemId: '',
        dicOptions: [],
        useSelectButton: false,
        buttonName: '选择数据',
        showLabel: false,
        showComponentBorder: true,
        showFormBorder: true,
        showIndex: false,
        multipleHeads: [],
      },
    },
    {
      key: 'ac18952da41b45c9a66ffba3e42b7f3d',
      field: 'filePath',
      label: '附件',
      type: 'upload',
      component: 'Upload',
      colProps: { span: 24 },
      componentProps: {
        api: uploadApi,
        span: 24,
        defaultValue: [],
        accept: '',
        maxNumber: '',
        maxSize: '',
        showLabel: true,
        multiple: false,
        disabled: false,
        required: false,
        events: {},
        style: { width: '200px' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
