import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'ywzz',
    label: '业务组织',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'ywlx',
    label: '业务类型',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'dbrq',
    label: '调拨日期',
    defaultValue: undefined,
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD HH:mm:ss',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
  },

  {
    field: 'lydj',
    label: '来源单据',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'ck',
    label: '仓库',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2010539474382962690' },
      labelField: 'name',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'ywzz',
    title: '业务组织',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'ywlx',
    title: '业务类型',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'dbrq',
    title: '调拨日期',
    componentType: 'date',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'lydj',
    title: '来源单据',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'ck',
    title: '仓库',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'cgy',
    title: '仓管员',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'bd9fe96651fb4ac4811f4fead877c21e',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 8,
          list: [
            {
              key: '47ec86ca7bf342d798e4ef44e302f987',
              field: 'ywzz',
              label: '业务组织',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入业务组织',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '7166ca8f9cf844f1861534df71c2a89b',
              field: 'ywlx',
              label: '业务类型',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入业务类型',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'ed73ec07895c43f7a1afc23f91496d5b',
              field: 'dbrq',
              label: '调拨日期',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 7,
                defaultValue: '',
                width: '100%',
                placeholder: '请选择调拨日期',
                format: 'YYYY-MM-DD HH:mm:ss',
                showLabel: true,
                allowClear: true,
                disabled: false,
                required: true,
                isShow: true,
                rules: [],
                events: {},
                isGetCurrent: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                searchType: 'time',
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'a1dd47b56eb34e7297a71bbfb89a3979',
              field: 'lydj',
              label: '来源单据',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入来源单据',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '86347f09a22e4ff68a08072bdfffa716',
              field: 'ck',
              label: '仓库',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择仓库',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                datasourceType: 'dic',
                params: { itemId: '2010539474382962690' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2010539474382962690',
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'c5649c27a36b4682aa4a876a6b471c62',
              field: 'cgy',
              label: '仓管员',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入仓管员',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: '1a65fa1a6bf944edb3f887d2b3e61624',
      label: '',
      field: 'mesWarehouseOtheroutInfoList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesWarehouseOtheroutInfoList',
        columns: [
          {
            key: '4db77e7fa1f04dedb3ab9bb8286b6125',
            title: '产品',
            dataIndex: 'cp',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入产品',
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: true,
              rules: [],
              events: {},
              listStyle: '',
              isSave: false,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
            },
          },
          {
            key: '1afd418afd6d4ac280f0c03f50753677',
            title: '规格',
            dataIndex: 'gg',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入规格',
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: false,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
            },
          },
          {
            key: '99ab56fd7393405885abab6ee9cb0cfe',
            title: '需求数量',
            dataIndex: 'xqsl',
            componentType: 'InputNumber',
            defaultValue: 0,
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: 0,
              min: 0,
              step: 1,
              disabled: false,
              showLabel: true,
              controls: true,
              required: false,
              subTotal: false,
              isShow: true,
              rules: [],
              events: {},
              tooltipConfig: { visible: false, title: '提示文本' },
              listStyle: "return 'width:100%'",
            },
          },
          {
            key: '5bb0d5bc6a01415598a54492c4c16b1d',
            title: '计量单位',
            dataIndex: 'jldw',
            componentType: 'XjrSelect',
            componentProps: {
              width: '100%',
              span: '',
              placeholder: '请选择计量单位',
              showLabel: true,
              showSearch: false,
              isMultiple: false,
              clearable: false,
              disabled: false,
              staticOptions: [
                { key: 1, label: 'Option 1', value: 'Option 1' },
                { key: 2, label: 'Option 2', value: 'Option 2' },
                { key: 3, label: 'Option 3', value: 'Option 3' },
              ],
              datasourceType: 'dic',
              params: { itemId: '2003765781699985410' },
              labelField: 'name',
              valueField: 'value',
              apiConfig: {
                path: 'CodeGeneration/selection',
                method: 'GET',
                apiId: '93d735dcb7364a0f8102188ec4d77ac7',
              },
              dicOptions: [],
              required: false,
              rules: [],
              events: {},
              isShow: true,
              tooltipConfig: { visible: false, title: '提示文本' },
              itemId: '2003765781699985410',
              listStyle: "return 'border: 0'",
            },
          },
          {
            key: '80e79f0e59f54d1fba7b2f0a14e2b5b1',
            title: '货位',
            dataIndex: 'hw',
            componentType: 'XjrSelect',
            componentProps: {
              width: '100%',
              span: '',
              placeholder: '请选择货位货位',
              showLabel: true,
              showSearch: false,
              isMultiple: false,
              clearable: false,
              disabled: false,
              staticOptions: [
                { key: 1, label: 'Option 1', value: 'Option 1' },
                { key: 2, label: 'Option 2', value: 'Option 2' },
                { key: 3, label: 'Option 3', value: 'Option 3' },
              ],
              datasourceType: 'api',
              params: null,
              labelField: 'label',
              valueField: 'value',
              apiConfig: {
                path: '/getStoreLocation',
                method: 'GET',
                apiId: 'd55f1866db284ecd8b038a3956b9c5b7',
                apiParams: [
                  { key: '1', title: 'Query Params', tableInfo: [] },
                  { key: '2', title: 'Header', tableInfo: [] },
                  { key: '3', title: 'Body' },
                ],
                script:
                  'var sql="select name as value,name as label from mes_storage_location where delete_mark = 0 ";\r\nreturn db.select(sql);',
              },
              dicOptions: [],
              required: false,
              rules: [],
              events: {},
              isShow: true,
              tooltipConfig: { visible: false, title: '提示文本' },
              itemId: '2010541442849521665',
              defaultSelect: null,
              listStyle: "return 'border: 0'",
            },
          },
          {
            key: '8607126fb71a44eb91a9e0d0506a1888',
            title: '备注',
            dataIndex: 'bz',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入备注',
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: false,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        span: '24',
        preloadType: 'api',
        apiConfig: {},
        itemId: '',
        dicOptions: [],
        useSelectButton: false,
        buttonName: '选择数据',
        showLabel: true,
        showComponentBorder: true,
        showBorder: false,
        bordercolor: '#f0f0f0',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        showIndex: true,
        isShow: true,
        multipleHeads: [],
        buttonList: [],
        topButtonList: [],
        isExport: true,
        isImport: true,
        isDeleteSelected: false,
        isListView: false,
        viewList: [],
        isShowAdd: true,
        isShowDelete: true,
        hasCheckedCol: false,
        events: {},
        showPagenation: true,
        showColunmSet: true,
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
