import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesProcessTechnology分页参数 模型
 */
export interface MesProcessTechnologyPageParams extends BasicPageParams {
  processCode: string;

  processName: string;

  materialId: string;

  remark: string;
}

/**
 * @description: MesProcessTechnology分页返回值模型
 */
export interface MesProcessTechnologyPageModel {
  id: string;

  processCode: string;

  processName: string;

  materialId: string;

  remark: string;

  createUserId: string;

  createDate: string;
}

/**
 * @description: MesProcessTechnology表类型
 */
export interface MesProcessTechnologyModel {
  id: number;

  isSysNum: string;

  processCode: string;

  processName: string;

  materialId: string;

  state: number;

  sort: number;

  remark: string;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;

  mesProcessTechnologyStepList?: MesProcessTechnologyStepModel;
}

/**
 * @description: MesProcessTechnologyStep表类型
 */
export interface MesProcessTechnologyStepModel {
  id: number;

  techId: string;

  processId: string;

  processName: string;

  preCondition: string;

  staCondition: string;

  state: number;

  sort: number;

  remark: string;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesProcessTechnology分页返回值结构
 */
export type MesProcessTechnologyPageResult = BasicFetchResult<MesProcessTechnologyPageModel>;
