import { MesProcessModel, MesProcessPageParams, MesProcessPageResult } from './model/ProcessModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/process/page',
  List = '/mes/process/list',
  Info = '/mes/process/info',
  MesProcess = '/mes/process',
  
  
}

/**
 * @description: 查询MesProcess分页列表
 */
export async function getMesProcessPage(params: MesProcessPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProcessPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesProcess信息
 */
export async function getMesProcess(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProcessModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesProcess
 */
export async function addMesProcess(mesProcess: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesProcess,
      params: mesProcess,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesProcess
 */
export async function updateMesProcess(mesProcess: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesProcess,
      params: mesProcess,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesProcess（批量删除）
 */
export async function deleteMesProcess(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesProcess,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}